/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThreadPool;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

public class StaticJobExecutorThreadPool
implements JobExecutorThreadPool {
    private static final Log LOG = Log.getLog(StaticJobExecutorThreadPool.class.getName());
    private final List<JobExecutorThread> jobExecutorThreads = new ArrayList<JobExecutorThread>();
    private final PvmJobExecutor jobExecutor;

    public StaticJobExecutorThreadPool(PvmJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    private JobExecutorThread startThread() {
        String threadName = this.getNextThreadName();
        JobExecutorThread jobExecutorThread = new JobExecutorThread(threadName, this.jobExecutor);
        this.jobExecutorThreads.add(jobExecutorThread);
        LOG.trace("starting " + threadName);
        jobExecutorThread.start();
        return jobExecutorThread;
    }

    public void start() {
        for (int i = 0; i < this.jobExecutor.getNbrOfThreads(); ++i) {
            this.startThread();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean join) {
        for (JobExecutorThread jobExecutorThread : this.jobExecutorThreads) {
            jobExecutorThread.stop(join);
        }
    }

    protected String getNextThreadName() {
        return "JobExecutorThread" + this.jobExecutorThreads.size();
    }
}

