/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.pvm.internal.util.PvmXmlUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ArgDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.operation.Operation;
import org.ow2.orchestra.pvm.internal.wire.xml.WireParser;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectBinding
extends WireDescriptorBinding {
    public ObjectBinding() {
        super("object");
    }

    public static boolean isObjectDescriptor(Element element) {
        if (XmlUtil.attribute((Element)element, (String)"class") != null) {
            return true;
        }
        if (XmlUtil.attribute((Element)element, (String)"factory") != null) {
            return true;
        }
        return XmlUtil.element((Element)element, (String)"factory") != null;
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor descriptor = new ObjectDescriptor();
        WireParser wireParser = (WireParser)parser;
        String className = XmlUtil.attribute((Element)element, (String)"class");
        String factoryObjectName = XmlUtil.attribute((Element)element, (String)"factory");
        Element factoryElement = XmlUtil.element((Element)element, (String)"factory");
        if (className != null) {
            Element constructorElement;
            descriptor.setClassName(className);
            if (factoryObjectName != null) {
                parse.addProblem("attribute 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString((Node)element));
            }
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString((Node)element));
            }
            if ((constructorElement = XmlUtil.element((Element)element, (String)"constructor")) != null) {
                List argElements = XmlUtil.elements((Element)constructorElement, (String)"arg");
                List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
                descriptor.setArgDescriptors(argDescriptors);
                if (element.hasAttribute("method")) {
                    parse.addProblem("attributes 'class' and 'method' indicate static method and also a 'constructor' element is specified for element 'object': " + XmlUtil.toString((Node)element));
                }
            }
        } else if (factoryObjectName != null) {
            descriptor.setFactoryObjectName(factoryObjectName);
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'factory' in element 'object': " + XmlUtil.toString((Node)element));
            }
        } else if (factoryElement != null) {
            Element factoryDescriptorElement = XmlUtil.element((Element)factoryElement);
            Descriptor factoryDescriptor = (Descriptor)parser.parseElement(factoryDescriptorElement, parse, "descriptor");
            descriptor.setFactoryDescriptor(factoryDescriptor);
        } else {
            parse.addProblem("element 'object' must have one of {attribute 'class', attribute 'factory' or element 'factory'}: " + XmlUtil.toString((Node)element));
        }
        if (element.hasAttribute("method")) {
            descriptor.setMethodName(element.getAttribute("method"));
            List argElements = XmlUtil.elements((Element)element, (String)"arg");
            List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
            descriptor.setArgDescriptors(argDescriptors);
        } else if (className == null) {
            parse.addProblem("element 'object' with a element 'factory' or a attribute 'factory' must have a attribute 'method': " + XmlUtil.toString((Node)element));
        }
        if (className == null && XmlUtil.element((Element)element, (String)"constructor") != null) {
            parse.addProblem("element 'object' with a element 'factory' or a attribute 'factory' can't have a 'constructor' element: " + XmlUtil.toString((Node)element));
        }
        ArrayList<Operation> operations = null;
        List elements = XmlUtil.elements((Element)element);
        if (elements != null) {
            for (Element childElement : elements) {
                if (childElement.getTagName().equals("constructor") || childElement.getTagName().equals("factory") || childElement.getTagName().equals("arg")) continue;
                Operation operation = (Operation)parser.parseElement(childElement, parse, "operation");
                if (operation != null) {
                    if (operations == null) {
                        operations = new ArrayList<Operation>();
                    }
                    operations.add(operation);
                    continue;
                }
                parse.addProblem("element 'object' can only have 'factory', 'arg', 'constructor' elements or an operation element (" + parser.getBindings().getTagNames("operation") + ")." + " Invalid element '" + childElement.getTagName() + "' in: " + XmlUtil.toString((Node)element));
            }
        }
        descriptor.setOperations(operations);
        Boolean isAutoWireEnabled = PvmXmlUtil.attributeBoolean(element, "auto-wire", false, parse);
        if (isAutoWireEnabled != null) {
            descriptor.setAutoWireEnabled(isAutoWireEnabled);
        }
        return descriptor;
    }
}

