/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.deploy.DeployerManager;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerManagerDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> extensions = new HashMap<String, String>();
    protected Map<String, List<Descriptor>> deployerDescriptors = new HashMap<String, List<Descriptor>>();

    @Override
    public Object construct(WireContext wireContext) {
        return new DeployerManager();
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        DeployerManager deployerManager = (DeployerManager)object;
        HashMap<String, List<Deployer>> deployers = new HashMap<String, List<Deployer>>();
        for (Map.Entry<String, List<Descriptor>> languageEntry : this.deployerDescriptors.entrySet()) {
            String language = languageEntry.getKey();
            List<Descriptor> descriptors = languageEntry.getValue();
            ArrayList<Deployer> deployerSequence = new ArrayList<Deployer>();
            for (Descriptor descriptor : descriptors) {
                deployerSequence.add((Deployer)wireContext.create(descriptor, true));
            }
            deployers.put(language, deployerSequence);
        }
        deployerManager.setExtensions(this.extensions);
        deployerManager.setDeployers(deployers);
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return DeployerManager.class;
    }

    public void addLanguage(String language, String extension, List<Descriptor> deployerDescriptorSequence) {
        if (extension != null) {
            this.extensions.put(extension, language);
        }
        this.deployerDescriptors.put(language, deployerDescriptorSequence);
    }
}

