/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import org.h2.log.LogFile;
import org.h2.message.Message;
import org.h2.store.PageStore;

public class InDoubtTransaction {
    public static final int IN_DOUBT = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private final PageStore store;
    private final LogFile log;
    private final int sessionId;
    private final int pos;
    private final String transaction;
    private final int blocks;
    private int state;

    public InDoubtTransaction(PageStore pageStore, LogFile logFile, int n, int n2, String string, int n3) {
        this.store = pageStore;
        this.log = logFile;
        this.sessionId = n;
        this.pos = n2;
        this.transaction = string;
        this.blocks = n3;
        this.state = 0;
    }

    public void setState(int n) throws SQLException {
        switch (n) {
            case 1: {
                if (this.store != null) {
                    this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                    break;
                }
                this.log.updatePreparedCommit(true, this.pos, this.sessionId, this.blocks);
                break;
            }
            case 2: {
                if (this.store != null) {
                    this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                    break;
                }
                this.log.updatePreparedCommit(false, this.pos, this.sessionId, this.blocks);
                break;
            }
            default: {
                Message.throwInternalError("state=" + n);
            }
        }
        this.state = n;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw Message.throwInternalError("state=" + this.state);
    }

    public String getTransaction() {
        return this.transaction;
    }
}

