/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.blremover;

import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class BlankLineRemoverService
implements Analyser {
    private final Log log = LogFactory.getLog(this.getClass());

    public ProcessReturn process(ProcessArgs args) throws InvalidParameterException {
        this.log.debug((Object)"Start of process method.");
        List textList = this.checkArgs(args);
        Resource res = args.getResource();
        this.log.info((Object)("Beginning process with MediaUnit: " + res.getUri() + "."));
        Pattern p = Pattern.compile("^\\s+$", 8);
        for (Text text : textList) {
            String textContent = text.getContent();
            textContent = textContent.trim();
            textContent = p.matcher(textContent).replaceAll("\n");
            textContent = textContent.replace("\r\n", "\n");
            textContent = textContent.replaceAll("[\\r\\n]{2,}|(?:\\r\\n){2,}$", "\n\n");
            text.setContent(textContent);
        }
        ProcessReturn pr = new ProcessReturn();
        pr.setResource(res);
        this.log.info((Object)("MediaUnit: " + res.getUri() + " successfully processed."));
        return pr;
    }

    private List<Text> checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("ProcessArgs was null.", "ProcessArgs was null.");
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new InvalidParameterException("Resource in ProcessArgs was null.", "Resource in ProcessArgs was null.");
        }
        if (!(res instanceof Document)) {
            throw new InvalidParameterException("Resource in ProcessArgs was not a Document, but a " + res.getClass().getName() + ".", "URI of the buggy resource: " + res.getUri() + ".");
        }
        List texts = ResourceUtil.getSelectedSubResources((Resource)args.getResource(), Text.class);
        ListIterator textIt = texts.listIterator();
        while (textIt.hasNext()) {
            Text text = (Text)textIt.next();
            if (text.getContent() != null) continue;
            textIt.remove();
        }
        return texts;
    }
}

