/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.repository.file.RepoRI;

public class FileRepository {
    protected final File pathToFS;
    protected final String filePrefix;
    protected final String repositoryID;
    protected final int filePerFolder;
    protected final Log log;
    protected File currentFolder;
    protected final WebLabMarshaller wlm = new WebLabMarshaller();

    public FileRepository(String pathToTheRepository, int filePerFolder, String repositoryID, String filePrefix) throws IOException {
        this.log = LogFactory.getLog(this.getClass());
        this.filePrefix = filePrefix;
        this.filePerFolder = filePerFolder;
        this.repositoryID = repositoryID;
        this.pathToFS = this.initPathToFS(pathToTheRepository);
        this.createNewSubFolder();
        this.log.debug((Object)("Repository initialised on " + this.pathToFS.getAbsolutePath() + "."));
    }

    public Resource getResource(String uri) throws WebLabCheckedException, FileNotFoundException {
        Resource res;
        RepoRI wlRi = new RepoRI(uri);
        try {
            res = this.loadFile(wlRi.getIdResource() + ".xml");
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Uri '" + uri + "' is not present in the repository.");
        }
        Resource result = this.getResourceInside(res, uri);
        if (result == null) {
            throw new FileNotFoundException("Uri '" + uri + "' is not present in the repository.");
        }
        return result;
    }

    public String saveResource(Resource resource) throws WebLabCheckedException {
        Resource res = this.changeUri(resource);
        try {
            this.writeFile(new RepoRI(res.getUri()), res);
        }
        catch (FileNotFoundException fnfe) {
            throw new WebLabCheckedException("Unable to write resource: " + resource.getUri() + " into resource: " + res.getUri() + ".", (Throwable)fnfe);
        }
        return res.getUri();
    }

    protected Resource getResourceInside(Resource res, String uri) throws WebLabCheckedException {
        return this.getResourceInside(res, uri, null);
    }

    protected Resource getResourceInside(Resource res, String uri, Resource newRes) throws WebLabCheckedException {
        return this.getResourceInside(res, uri, newRes, null);
    }

    protected Resource getResourceInside(Resource res, String uri, Resource newRes, Resource father) throws WebLabCheckedException {
        if (res.getUri().equals(uri)) {
            if (newRes != null) {
                this.replaceResource(father, res, newRes);
            }
            return res;
        }
        ArrayList listAnnotCopy = new ArrayList(res.getAnnotation());
        Resource ret = null;
        Iterator itAnnot = listAnnotCopy.iterator();
        while (ret == null && itAnnot.hasNext()) {
            ret = this.getResourceInside((Resource)itAnnot.next(), uri, newRes, res);
        }
        if (ret != null) {
            return ret;
        }
        if (res instanceof Document) {
            Document document = (Document)res;
            ArrayList listMediaUnitCopy = new ArrayList(document.getMediaUnit());
            Iterator itMed = listMediaUnitCopy.iterator();
            while (ret == null && itMed.hasNext()) {
                ret = this.getResourceInside((Resource)itMed.next(), uri, newRes, res);
            }
            if (ret != null) {
                return ret;
            }
        }
        return ret;
    }

    protected void replaceResource(Resource father, Resource oldRes, Resource newRes) throws WebLabCheckedException {
        if (newRes instanceof MediaUnit && father instanceof Document) {
            MediaUnit newMed = (MediaUnit)newRes;
            Document fatherDoc = (Document)father;
            int index = fatherDoc.getMediaUnit().indexOf(oldRes);
            fatherDoc.getMediaUnit().remove(oldRes);
            fatherDoc.getMediaUnit().add(index, newMed);
        } else if (newRes instanceof Annotation) {
            Annotation newAnnot = (Annotation)newRes;
            int index = father.getAnnotation().indexOf(oldRes);
            father.getAnnotation().remove(oldRes);
            father.getAnnotation().add(index, newAnnot);
        } else {
            throw new WebLabCheckedException("In the document repository, the uri '" + newRes.getUri() + "' is a '" + oldRes.getClass() + "' and is not replacable by a '" + newRes.getClass() + "'.");
        }
    }

    protected synchronized Resource loadFile(String fileName) throws WebLabCheckedException, FileNotFoundException {
        File file = new File(this.pathToFS.getAbsoluteFile(), fileName);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " not found.");
        }
        return this.wlm.unmarshal(file, Resource.class);
    }

    protected Resource changeUri(Resource res) throws WebLabCheckedException {
        Resource ret;
        RepoRI wlRi;
        try {
            wlRi = new RepoRI(res.getUri());
        }
        catch (WebLabCheckedException wlce) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to load a valid WLRI: '" + res.getUri() + "'."), (Throwable)wlce);
            wlRi = null;
        }
        if (wlRi != null && wlRi.getIdReference().equals(this.repositoryID)) {
            File file = new File(this.pathToFS, wlRi.getIdResource() + ".xml");
            if (!file.exists()) {
                wlRi = new RepoRI("weblab://" + this.repositoryID + "/" + this.getUniqueResource());
                ret = this.replaceUri(res, wlRi.toString());
            } else {
                ret = res;
            }
        } else {
            wlRi = new RepoRI("weblab://" + this.repositoryID + "/" + this.getUniqueResource());
            ret = this.replaceUri(res, wlRi.toString());
        }
        return ret;
    }

    protected String getUniqueResource() {
        int max = -1;
        if (this.currentFolder != null) {
            if (this.currentFolder.listFiles().length >= this.filePerFolder) {
                this.createNewSubFolder();
            }
        } else {
            this.createNewSubFolder();
        }
        for (File file : this.currentFolder.listFiles()) {
            int val;
            String fileName = file.getName().substring(0, file.getName().length() - 4);
            if (!fileName.startsWith(this.filePrefix) || (val = Integer.parseInt(fileName.substring(this.filePrefix.length()))) <= max) continue;
            max = val;
        }
        return this.currentFolder.getName() + "/" + this.filePrefix + (max + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource replaceUri(Resource res, String uri) throws WebLabCheckedException {
        Resource ret;
        ByteArrayInputStream bais;
        String newXmlStr;
        URI wlRi;
        try {
            wlRi = new URI(res.getUri());
        }
        catch (URISyntaxException urise) {
            throw new WebLabCheckedException("Unvalid URI: '" + res.getUri() + "'.", (Throwable)urise);
        }
        String oldUri = wlRi.toString();
        if (wlRi.getFragment() != null) {
            oldUri = res.getUri().substring(0, res.getUri().indexOf(35));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.wlm.marshalResource(res, (OutputStream)baos);
            String oldStr = baos.toString("UTF-8");
            newXmlStr = oldStr.replaceAll(oldUri, uri);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("Unable to handle encoding.", (Throwable)uee);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        try {
            bais = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("Unable to handle encoding.", (Throwable)uee);
        }
        try {
            ret = this.wlm.unmarshal((InputStream)bais, Resource.class);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bais);
        }
        return ret;
    }

    protected synchronized void writeFile(RepoRI wlRi, Resource res) throws FileNotFoundException, WebLabCheckedException {
        Resource newRes;
        File saveFile = new File(this.pathToFS.getAbsolutePath(), wlRi.getIdResource() + ".xml");
        if (saveFile.exists() && wlRi.getFragment() != null) {
            newRes = this.loadFile(wlRi.getIdResource() + ".xml");
            this.getResourceInside(newRes, res.getUri(), res);
        } else {
            newRes = res;
        }
        this.wlm.marshalResource(newRes, saveFile);
    }

    protected File initPathToFS(String pathToTheRepository) throws IOException {
        if (pathToTheRepository == null) {
            throw new IOException("Unable to create a folder with null as name.");
        }
        File file = new File(pathToTheRepository);
        if (!file.isAbsolute()) {
            this.log.warn((Object)"The path to the repository is not absolute. This might lead to problem if the server is not started from the same location.");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create folder " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Unable to create folder " + file.getAbsolutePath() + " since a file with the same name exists.");
        }
        return file;
    }

    protected void createNewSubFolder() {
        File folder = new File(this.pathToFS.getAbsolutePath(), "" + System.currentTimeMillis());
        this.setCurrentFolder(folder);
    }

    protected void setCurrentFolder(File currentFolder) {
        this.currentFolder = currentFolder;
        if (!currentFolder.exists() && !currentFolder.mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create folder. RuntimeException may appears.");
        }
    }
}

