/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabRISyntaxException;

public class RepoRI {
    public static final String WLRI_REGEX = "^weblab:(//([^/?#\\n]+))+/(([^/?#\\n][^?#\\n]+)(\\?([^#\\n]+))?)+(#([^\\n]+))?";
    public static final String WLRI_SCHEME = "weblab";
    private URI uri;
    private String idReference;
    private String idResource;
    private final String fragment;

    public RepoRI(String uriStr) throws WebLabCheckedException {
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException urise) {
            throw new WebLabCheckedException("Unable to create URI from: '" + uriStr + "'.", (Throwable)urise);
        }
        if (!WLRI_SCHEME.equals(this.uri.getScheme())) {
            throw new WebLabCheckedException("Scheme must be weblab, founded " + this.uri.getScheme());
        }
        Pattern p = Pattern.compile(WLRI_REGEX);
        Matcher m = p.matcher(uriStr);
        if (!m.matches()) {
            throw new WebLabCheckedException("Invalid WebLabRI: '" + uriStr + "'.");
        }
        this.idReference = m.group(2);
        this.idResource = m.group(3);
        this.fragment = this.uri.getFragment();
    }

    public void addFragment(String fragmentToAdd) {
        if (this.uri.getFragment() == null) {
            try {
                this.uri = new URI(this.uri.toString() + "#" + fragmentToAdd);
            }
            catch (URISyntaxException urise) {
                throw new WebLabRISyntaxException(urise);
            }
        }
        try {
            this.uri = new URI(this.uri.toString() + "-" + fragmentToAdd);
        }
        catch (URISyntaxException urise) {
            throw new WebLabRISyntaxException(urise);
        }
    }

    public String getIdReference() {
        return this.idReference;
    }

    public String getIdResource() {
        return this.idResource;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.uri.toString();
    }

    public static boolean checkValidity(String uri) {
        URI newUri;
        try {
            newUri = new URI(uri);
        }
        catch (URISyntaxException urise) {
            LogFactory.getLog(RepoRI.class).debug((Object)(uri + " is not a valid URI."));
            return false;
        }
        if (!WLRI_SCHEME.equals(newUri.getScheme())) {
            LogFactory.getLog(RepoRI.class).debug((Object)(uri + " is not a RepoRI."));
            return false;
        }
        Pattern p = Pattern.compile(WLRI_REGEX);
        Matcher m = p.matcher(uri);
        return m.matches();
    }
}

