/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceReturn;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceReturn;
import org.ow2.weblab.repository.file.FileRepository;

@WebService(endpointInterface="org.ow2.weblab.core.services.ResourceContainer")
public class FileRepositoryService
implements ResourceContainer {
    public static final String DEFAULT_REPO_ID = "fileRepository";
    public static final String DEFAULT_PATH = "repository";
    public static final int DEFAULT_FILE_PER_FOLDER = 1000;
    public static final String DEFAULT_FILE_PREFIX = "res_";
    protected final FileRepository repo;
    protected final Log log = LogFactory.getLog(this.getClass());

    public FileRepositoryService() {
        this(DEFAULT_PATH);
    }

    public FileRepositoryService(String pathToTheRepository) {
        this(pathToTheRepository, 1000);
    }

    public FileRepositoryService(String pathToTheRepository, int numberOfFilePerFolder) {
        this(pathToTheRepository, numberOfFilePerFolder, DEFAULT_REPO_ID, DEFAULT_FILE_PREFIX);
    }

    public FileRepositoryService(String pathToTheRepository, int numberOfFilePerFolder, String repoId, String filePrefix) {
        try {
            this.repo = new FileRepository(pathToTheRepository, numberOfFilePerFolder, repoId, filePrefix);
        }
        catch (IOException ioe) {
            this.log.fatal((Object)"Service cannot be started due to an IOException at initialisation.", (Throwable)ioe);
            throw new WebLabUncheckedException((Throwable)ioe);
        }
    }

    public LoadResourceReturn loadResource(LoadResourceArgs args) throws InvalidParameterException, UnexpectedException {
        Resource res;
        if (args == null) {
            throw new InvalidParameterException("LoadResourceArgs was null.", "LoadResourceArgs was null.");
        }
        String resId = args.getResourceId();
        if (resId == null || "".equals(resId.trim())) {
            throw new InvalidParameterException("ResourceId in LoadResourceArgs was null or empty.", "ResourceId in LoadResourceArgs was null or empty.");
        }
        try {
            res = this.repo.getResource(resId);
        }
        catch (FileNotFoundException fnfe) {
            this.log.error((Object)("Unable to get resource from URI " + resId + "."), (Throwable)fnfe);
            throw new InvalidParameterException("Unable to get resource from URI " + resId + ".", "Unable to get resource from URI " + resId + ".", (Throwable)fnfe);
        }
        catch (WebLabCheckedException wlce) {
            this.log.error((Object)("Unable to get resource from URI " + resId + "."), (Throwable)wlce);
            throw new UnexpectedException("Unable to get resource from URI " + resId + ".", "Unable to get resource from URI " + resId + ".", (Throwable)wlce);
        }
        LoadResourceReturn ret = new LoadResourceReturn();
        ret.setResource(res);
        return ret;
    }

    public SaveResourceReturn saveResource(SaveResourceArgs args) throws InvalidParameterException, UnexpectedException {
        String resId;
        if (args == null) {
            throw new InvalidParameterException("SaveResourceArgs was null.", "SaveResourceArgs was null.");
        }
        Resource res = args.getResource();
        if (res == null || res.getUri() == null) {
            throw new InvalidParameterException("Resource SaveResourceException was null or without URI.", "Resource SaveResourceException was null or without URI.");
        }
        try {
            resId = this.repo.saveResource(res);
        }
        catch (WebLabCheckedException wlce) {
            String msg = "Unable to save resource with URI " + res.getUri() + ".";
            this.log.error((Object)msg, (Throwable)wlce);
            throw new UnexpectedException(msg, msg, (Throwable)wlce);
        }
        SaveResourceReturn ret = new SaveResourceReturn();
        ret.setResourceId(resId);
        return ret;
    }
}

