/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.crawler.folder.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.api.ContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.EmptyQueueException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.configurable.ConfigureArgs;
import org.ow2.weblab.core.services.configurable.ConfigureReturn;
import org.ow2.weblab.core.services.configurable.ResetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.ResetConfigurationReturn;
import org.ow2.weblab.core.services.queuemanager.NextResourceArgs;
import org.ow2.weblab.core.services.queuemanager.NextResourceReturn;
import org.ow2.weblab.core.services.sourcereader.GetResourceArgs;
import org.ow2.weblab.core.services.sourcereader.GetResourceReturn;
import org.ow2.weblab.crawler.FolderCrawler;
import org.ow2.weblab.crawler.filter.ExtensionFilter;
import org.ow2.weblab.services.crawler.folder.impl.IFolderCrawler;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService
@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
public class FolderCrawlerService
implements IFolderCrawler {
    Log logger = LogFactory.getLog(FolderCrawlerService.class);
    private static final String FOLDER_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/processing#crawler/folder";
    protected ContentManager contentManager = null;
    public static final String DEFAULT_FOLDER = "toBeCrawled";
    public static final String FOLDERS_FILE = "FolderCrawlerService.config";
    private static final String FOLDERS = "folders";
    private static final String EXTENSIONS = "extensions";
    private static final String REJECT = "reject";
    private static final String RECURSIVE = "recursive";
    protected Map<String, String> props = null;
    protected Map<String, List<String>> usContextAndFolderToCrawl = new HashMap();
    protected Map<String, List<FolderCrawler>> usContextAndFolderCrawler = new HashMap();
    protected Map<String, Integer> usContextAndOffset = new HashMap();

    public FolderCrawlerService() throws AccessDeniedException {
        if (this.contentManager == null) {
            try {
                this.contentManager = ContentManager.getInstance();
            }
            catch (WebLabUncheckedException wlue) {
                throw new AccessDeniedException("Unable to get the content manager. ", wlue.getMessage());
            }
        }
    }

    protected void startCrawl(String uc, boolean alreadyConfigured) {
        List filesToCrawl = null;
        if (alreadyConfigured) {
            filesToCrawl = (List)this.usContextAndFolderToCrawl.get(uc);
        } else {
            this.logger.info((Object)"Folder will be loaded from config file.");
            filesToCrawl = this.getFoldersFromConfig();
        }
        ArrayList<FolderCrawler> fcList = new ArrayList<FolderCrawler>();
        boolean recursive = this.getRecursiveFromConfig();
        FileFilter ff = this.getFileFilterFromConfig();
        for (String toCrawl : filesToCrawl) {
            FolderCrawler fc;
            try {
                fc = this.createFolderCrawler(recursive, ff, toCrawl);
            }
            catch (WebLabCheckedException wlce) {
                this.logger.warn((Object)("Unable to crawl folder: " + toCrawl), (Throwable)wlce);
                continue;
            }
            fc.startCrawl();
            fcList.add(fc);
        }
        this.usContextAndFolderCrawler.put(uc, fcList);
    }

    protected FolderCrawler createFolderCrawler(boolean recursive, FileFilter ff, String toCrawl) throws WebLabCheckedException {
        FolderCrawler fc = new FolderCrawler(this.contentManager, new File(toCrawl), ff, recursive);
        return fc;
    }

    private boolean getRecursiveFromConfig() {
        boolean rec;
        if (this.props == null) {
            this.loadProps();
        }
        if (this.props.containsKey("recursive")) {
            rec = Boolean.parseBoolean((String)this.props.get("recursive"));
        } else {
            this.logger.warn((Object)"Unable to load recursive from config file. false will be used.");
            rec = false;
        }
        return rec;
    }

    private FileFilter getFileFilterFromConfig() {
        boolean rej;
        if (this.props == null) {
            this.loadProps();
        }
        if (this.props.containsKey("reject")) {
            rej = Boolean.parseBoolean((String)this.props.get("reject"));
        } else {
            this.logger.warn((Object)"Unable to load reject from config file. false will be used.");
            rej = false;
        }
        ArrayList<String> ext = new ArrayList<String>();
        if (this.props.containsKey("extensions")) {
            String[] splitted;
            for (String string : splitted = ((String)this.props.get("extensions")).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                ext.add(string);
            }
            if (ext.isEmpty()) {
                this.logger.info((Object)"Extensions is empty; from FolderCrawlerService.config");
            }
        } else {
            this.logger.warn((Object)"Unable to get extensions from FolderCrawlerService.config");
        }
        return new ExtensionFilter(ext, rej);
    }

    @WebMethod(action="next")
    @WebResult(name="nextResourceReturn", targetNamespace="http://weblab.ow2.org/core/1.2/services/queuemanager", partName="return")
    public NextResourceReturn nextResource(@WebParam(name="nextResourceArgs", targetNamespace="http://weblab.ow2.org/core/1.2/services/queuemanager", partName="args") NextResourceArgs args) throws AccessDeniedException, ContentNotAvailableException, EmptyQueueException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        Integer offset_l = (Integer)this.usContextAndOffset.get(args.getUsageContext());
        if (offset_l == null) {
            offset_l = 0;
        }
        NextResourceReturn ret = new NextResourceReturn();
        ComposedResource cr_l = this.getResources(1, offset_l.intValue(), args.getUsageContext());
        if (cr_l.getResource().isEmpty()) {
            throw new EmptyQueueException("No more resource for " + args.getUsageContext());
        }
        ret.setResource((Resource)cr_l.getResource().get(0));
        this.usContextAndOffset.put(args.getUsageContext(), offset_l + 1);
        return ret;
    }

    @WebMethod(action="getResource")
    @WebResult(name="getResourceReturn", targetNamespace="http://weblab.ow2.org/core/1.2/services/sourcereader", partName="return")
    public GetResourceReturn getResource(@WebParam(name="getResourceArgs", targetNamespace="http://weblab.ow2.org/core/1.2/services/sourcereader", partName="args") GetResourceArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        int limit = -1;
        int offset = 0;
        if (args != null) {
            limit = args.getLimit();
            offset = args.getOffset();
        }
        this.logger.info((Object)("GetCrawledDocuments method called. offset: " + offset + "; limit: " + limit));
        GetResourceReturn ret = new GetResourceReturn();
        String uc = null;
        if (args != null && args.getUsageContext() != null) {
            uc = args.getUsageContext();
        }
        ComposedResource resCol = this.getResources(limit, offset, uc);
        ret.setResources(resCol);
        return ret;
    }

    private ComposedResource getResources(int limit, int offset, String uc) throws InvalidParameterException {
        List fcList;
        ComposedResource resCol;
        if (uc == null || uc.length() == 0) {
            throw new InvalidParameterException("Unable to get resource on folder crawler.", "Usage context must not be null.");
        }
        if (!this.usContextAndFolderCrawler.containsKey(uc)) {
            if (this.usContextAndFolderToCrawl.containsKey(uc)) {
                this.startCrawl(uc, true);
            } else {
                this.startCrawl(uc, false);
            }
        }
        if ((resCol = FolderCrawlerService.getRCFromList((List)(fcList = (List)this.usContextAndFolderCrawler.get(uc)), (int)offset, (int)limit)).getResource().size() == 0) {
            this.logger.info((Object)"No resources in the resource collection returned by the crawler...");
            this.logger.info((Object)("FoldersCrawler were: " + fcList));
        }
        return resCol;
    }

    private static ComposedResource getRCFromList(List<FolderCrawler> fcList, int offset, int limit) {
        if (fcList == null || fcList.isEmpty()) {
            LogFactory.getLog(FolderCrawlerService.class).warn((Object)"No folder to crawl");
            return (ComposedResource)ResourceFactory.createResource((String)"folderCrawlerService", (String)("emptyCollection" + System.currentTimeMillis()), ComposedResource.class);
        }
        int usedOffset = offset < 0 ? 0 : offset;
        int usedLimit = limit <= 0 ? Integer.MAX_VALUE : limit;
        int cpt = 0;
        ComposedResource resCol = (ComposedResource)ResourceFactory.createResource((String)"folderCrawlerService", (String)("tempCollection-" + System.currentTimeMillis()), ComposedResource.class);
        for (FolderCrawler fc : fcList) {
            if (cpt + fc.getNbFiles() < usedOffset) {
                cpt += fc.getNbFiles();
                continue;
            }
            if (cpt >= usedOffset + usedLimit) break;
            resCol.getResource().addAll(fc.getCrawledDocuments(usedOffset - cpt, usedLimit).getResource());
            cpt += fc.getNbFiles();
        }
        return resCol;
    }

    protected void loadProps() {
        this.props = PropertiesLoader.loadProperties((String)"FolderCrawlerService.config");
    }

    private List<String> getFoldersFromConfig() {
        if (this.props == null) {
            this.loadProps();
        }
        ArrayList<String> folders = new ArrayList<String>();
        if (this.props.containsKey("folders")) {
            String[] splitted;
            for (String string : splitted = ((String)this.props.get("folders")).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                folders.add(string);
            }
            if (folders.isEmpty()) {
                this.logger.warn((Object)("Unable to get folders from FolderCrawlerService.config. ( " + (String)this.props.get("folders") + ") Default folder will be used."));
                folders.add("toBeCrawled");
            }
        } else {
            this.logger.warn((Object)"Unable to load folders from FolderCrawlerService.config. Default folder will be used.");
            folders.add("toBeCrawled");
        }
        return folders;
    }

    @WebMethod(action="configure")
    @WebResult(name="configureReturn", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable", partName="return")
    public ConfigureReturn configure(@WebParam(name="configureArgs", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable", partName="args") ConfigureArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException {
        this.logger.info((Object)"Configure method called.");
        ResetConfigurationArgs resetConfigurationArgs = new ResetConfigurationArgs();
        resetConfigurationArgs.setUsageContext(args.getUsageContext());
        try {
            this.resetConfiguration(resetConfigurationArgs);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
        }
        if (args.getUsageContext() == null || args.getConfiguration() == null || args.getUsageContext() == null) {
            throw new InvalidParameterException("Unable to configure folder crawler.", "ConfigureArgs was invalid (either it self, usageContext, it's uri or configuration was null");
        }
        JenaPoKHelper helper = new JenaPoKHelper(args.getConfiguration());
        ArrayList list = new ArrayList();
        list.addAll(helper.getLitsOnPredSubj(args.getUsageContext(), "http://weblab.ow2.org/core/1.2/ontology/processing#crawler/folder"));
        list.addAll(helper.getRessOnPredSubj(args.getUsageContext(), "http://weblab.ow2.org/core/1.2/ontology/processing#crawler/folder"));
        if (list.isEmpty()) {
            throw new InvalidParameterException("Unable to configure folder crawler.", "No property 'http://weblab.ow2.org/core/1.2/ontology/processing#crawler/folder' in the configuration annotation.");
        }
        this.usContextAndFolderToCrawl.put(args.getUsageContext(), list);
        return new ConfigureReturn();
    }

    @WebMethod(action="resetConfiguration")
    @WebResult(name="resetConfigurationReturn", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable", partName="return")
    public ResetConfigurationReturn resetConfiguration(@WebParam(name="resetConfigurationArgs", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable", partName="args") ResetConfigurationArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException {
        this.logger.info((Object)"ResetConfiguration method called.");
        if (args.getUsageContext() != null) {
            if (!this.usContextAndFolderToCrawl.containsKey(args.getUsageContext())) {
                throw new InvalidParameterException("Unable to reset configuration on folder crawler.", "Usage context unknowed.");
            }
        } else {
            throw new InvalidParameterException("Unable to reset configuration on folder crawler.", "Usage context null.");
        }
        this.usContextAndFolderCrawler.remove(args.getUsageContext());
        this.usContextAndFolderToCrawl.remove(args.getUsageContext());
        return new ResetConfigurationReturn();
    }
}

