/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.services.iterator.messages;



/**
 * This class is an holder for every messages using in the service.
 * 
 * @author ymombrun
 * @date 2011-08-18
 */
public abstract class Keys {


	// Keys that are used in FolderResourceConf


	/**
	 * The key of the message to be printed when reset configuration is called with an <code>null</code> usageContext.
	 */
	public static final String C_CLEAR_CONF = "FolderResourceC.INFO.ClearConf";


	/**
	 * The key of the message to be printed when reset configuration is called with a usageContext.
	 */
	public static final String C_CONF = "FolderResourceC.INFO.Conf";


	/**
	 * The key of the message to be added in the exception when the configure args is <code>null</code>.
	 */
	public static final String C_CONF_ARGS_NULL = "FolderResourceC.ERROR.ConfArgsNull";


	/**
	 * The key of the warning message to be printed when configuration is called with a usageContext already configured.
	 */
	public static final String C_CONF_EXIST = "FolderResourceC.WARN.ConfExist";


	/**
	 * The key of the message to be added in the exception when the configuration in configure args is <code>null</code>.
	 */
	public static final String C_CONF_NULL = "FolderResourceC.ERROR.ConfNull";


	/**
	 * The key of the message to be added in the exception when the default path is not a directory.
	 */
	public static final String C_FILE_NOT_DIRECTORY = "FolderResourceC.ERROR.FileNotDirectory";


	/**
	 * The key of the message to be added in the exception when the default path is not a readable.
	 */
	public static final String C_FILE_NOT_READABLE = "FolderResourceC.ERROR.FileNotReadable";


	/**
	 * The key of the message to be added in the exception when the default path does not exist.
	 */
	public static final String C_FOLDER_NOT_EXIST = "FolderResourceC.ERROR.FolderNotExist";


	/**
	 * The key of the warning message to be printed when more than one configuration is found in the PoK.
	 */
	public static final String C_MORE_THAN_ONE_CONF = "FolderResourceC.WARN.MoreThanOneConf";


	/**
	 * The key of the warning message to be printed when the configuration contains more than one folder to crawl.
	 */
	public static final String C_MORE_THAN_ONE_FOLDER = "FolderResourceC.WARN.MoreThanOneFolder";


	/**
	 * The key of the message to be added in the exception when the configuration is empty.
	 */
	public static final String C_NO_CONFIG = "FolderResourceC.ERROR.NoConfig";


	/**
	 * The key of the message to be added in the exception when the configuration does not contain a folder to crawl.
	 */
	public static final String C_NO_FOLDER = "FolderResourceC.ERROR.NoFolder";


	/**
	 * The key of the warning message to be printed when the RDF type of the configuration is not found.
	 */
	public static final String C_NO_TYPE = "FolderResourceC.WARN.NoType";


	/**
	 * The key of the warning message to be printed when the configuration instance is not linked to the right usageContext.
	 */
	public static final String C_NO_UC = "FolderResourceC.WARN.NoUC";


	/**
	 * The key of the message to be added in the exception when the reset configuration args is <code>null</code>.
	 */
	public static final String C_RESET_CONF_NULL = "FolderResourceC.ERROR.ResetConfNull";


	/**
	 * The key of the message to be printed when reset configuration is called with a usageContext.
	 */
	public static final String C_RESET_UC = "FolderResourceC.INFO.ResetUC";


	/**
	 * The key of the message to be printed when folder resource configuration is started.
	 */
	public static final String C_STARTED = "FolderResourceC.INFO.Started";



	// Keys that are used in InterfacesMappingSingleton


	/**
	 * The key of the message to be printed with the configuration singleton is initialised.
	 */
	public final static String IMS_INITIALISED = "InterfacesMappingSingleton.INFO.Initialised";



	// Keys that are used in Messages


	/**
	 * The key of the warning message to be printed when a message is not found.
	 */
	public static final String M_MESSAGE_NOT_FOUND = "Messages.WARN.MessageNotFound";



	// Keys that are used in FolderResourceQM


	/**
	 * The key of the message to be added in the exception when nextResourceArgs is <code>null</code>.
	 */
	public static final String QM_ARGS_NULL = "FolderResourceQM.ERROR.ArgsNull";


	/**
	 * The key of the message to be added in the exception when no more resources are in the iterator.
	 */
	public static final String QM_EMPTY = "FolderResourceQM.ERROR.Empty";


	/**
	 * The key of the message to be added in the exception when the iterator returns a file that does not exists.
	 */
	public static final String QM_FILE_NOT_EXIST = "FolderResourceQM.ERROR.FileNotExist";


	/**
	 * The key of the message to be added in the exception when the iterator returns a file that is not a file.
	 */
	public static final String QM_FILE_NOT_FILE = "FolderResourceQM.ERROR.FileNotFile";


	/**
	 * The key of the message to be added in the exception when the iterator returns a file that is not readable.
	 */
	public static final String QM_FILE_NOT_READABLE = "FolderResourceQM.ERROR.FileNotReadable";


	/**
	 * The key of the warning message to be printed when logging the resource fails.
	 */
	public static final String QM_MARSHAL_ERROR = "FolderResourceQM.WARNING.MarshalError";


	/**
	 * The key of the message to be printed when the service next resource method is called.
	 */
	public static final String QM_NEXT_RESOURCE_CALLED = "FolderResourceQM.INFO.NextResourceCalled";


	/**
	 * The key of the message to be added in the exception when the iterator returns an object that is not a file.
	 */
	public static final String QM_NOT_A_FILE = "FolderResourceQM.ERROR.NotAFile";


	/**
	 * The key of the message to be added in the exception when an unknown usageContext is required.
	 */
	public static final String QM_NOT_CONFIGURED = "FolderResourceQM.ERROR.NotConfigured";


	/**
	 * The key of the message to be added in the exception when the default path is <code>null</code>.
	 */
	public static final String QM_PATH_NULL = "FolderResourceQM.ERROR.PathNull";


	/**
	 * The key of the message to be printed when the service has started.
	 */
	public static final String QM_STARTED = "FolderResourceQM.INFO.Started";


	/**
	 * The key of the message to be added in the exception when the iterator returns a file which unmarshaling fails.
	 */
	public static final String QM_UNMARSHAL_ERROR = "FolderResourceQM.ERROR.UnmarshalError";

}