/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.iterator;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Configurable;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.configurable.ConfigureArgs;
import org.ow2.weblab.core.services.configurable.ConfigureReturn;
import org.ow2.weblab.core.services.configurable.ResetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.ResetConfigurationReturn;
import org.ow2.weblab.services.iterator.ConfigurationBean;
import org.ow2.weblab.services.iterator.InterfacesMappingSingleton;
import org.ow2.weblab.services.iterator.messages.Messages;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.ow2.weblab.core.services.Configurable")
public class FolderResourceConf
implements Configurable {
    private final ConfigurationBean configuration;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final InterfacesMappingSingleton mapping = InterfacesMappingSingleton.getInstance();

    public FolderResourceConf(ConfigurationBean configuration) {
        this.configuration = configuration;
        this.logger.info((Object)Messages.getString((String)"FolderResourceC.INFO.Started"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigureReturn configure(ConfigureArgs args) throws InvalidParameterException, AccessDeniedException, UnexpectedException {
        if (args == null) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceC.ERROR.ConfArgsNull"));
        }
        String usageContext = args.getUsageContext();
        PieceOfKnowledge conf = args.getConfiguration();
        if (conf == null) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceC.ERROR.ConfNull", (Object[])new Object[]{usageContext}));
        }
        if (usageContext == null) {
            usageContext = "";
        }
        String folderToCrawl = this.readConfigPoK(usageContext, conf);
        File file = FolderResourceConf.checkFolder((String)folderToCrawl, (String)usageContext);
        Iterator it = FileUtils.iterateFiles((File)file, (IOFileFilter)this.configuration.getFileFilter(), (IOFileFilter)this.configuration.getDirectoryFilter());
        InterfacesMappingSingleton interfacesMappingSingleton = this.mapping;
        synchronized (interfacesMappingSingleton) {
            if (this.mapping.isConfigured(usageContext)) {
                this.logger.warn((Object)Messages.getString((String)"FolderResourceC.WARN.ConfExist", (Object[])new Object[]{usageContext}));
                this.mapping.removeConfiguration(usageContext);
            }
            this.logger.info((Object)Messages.getString((String)"FolderResourceC.INFO.Conf", (Object[])new Object[]{usageContext, file.getAbsolutePath()}));
            this.mapping.addToMap(usageContext, it);
        }
        return new ConfigureReturn();
    }

    public ResetConfigurationReturn resetConfiguration(ResetConfigurationArgs args) throws InvalidParameterException, UnexpectedException {
        if (args == null) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceC.ERROR.ResetConfNull"));
        }
        String usageContext = args.getUsageContext();
        if (usageContext == null) {
            this.logger.info((Object)Messages.getString((String)"FolderResourceC.INFO.ClearConf"));
            this.mapping.clearMap();
        } else {
            this.logger.info((Object)Messages.getString((String)"FolderResourceC.INFO.ResetUC", (Object[])new Object[]{usageContext}));
            this.mapping.removeConfiguration(usageContext);
        }
        return new ResetConfigurationReturn();
    }

    public String readConfigPoK(String usageContext, PieceOfKnowledge conf) throws InvalidParameterException {
        List linkedContexts;
        List types;
        JenaPoKHelper h = new JenaPoKHelper(conf);
        List resources = h.getRessOnPredSubj(this.configuration.getServiceUri(), this.configuration.getHasConfiguration());
        if (resources.isEmpty()) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceC.ERROR.NoConfig", (Object[])new Object[]{usageContext, this.configuration.getServiceUri(), this.configuration.getHasConfiguration()}));
        }
        String configUri = (String)resources.get(0);
        if (new HashSet(resources).size() > 1) {
            this.logger.warn((Object)Messages.getString((String)"FolderResourceC.WARN.MoreThanOneConf", (Object[])new Object[]{usageContext, this.configuration.getServiceUri(), this.configuration.getHasConfiguration(), configUri}));
        }
        if (!(types = h.getRessOnPredSubj(configUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type")).contains(this.configuration.getConfigurationType())) {
            this.logger.warn((Object)Messages.getString((String)"FolderResourceC.WARN.NoType", (Object[])new Object[]{usageContext, configUri, this.configuration.getConfigurationType()}));
        }
        if (!(linkedContexts = h.getLitsOnPredSubj(configUri, this.configuration.getIsLinkedToContext())).contains(usageContext)) {
            this.logger.warn((Object)Messages.getString((String)"FolderResourceC.WARN.NoUC", (Object[])new Object[]{usageContext, configUri, this.configuration.getIsLinkedToContext()}));
        }
        List foldersToCrawl = h.getLitsOnPredSubj(configUri, this.configuration.getHasFolderToCrawl());
        foldersToCrawl.addAll(h.getRessOnPredSubj(configUri, this.configuration.getHasFolderToCrawl()));
        if (foldersToCrawl.isEmpty()) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceC.ERROR.NoFolder", (Object[])new Object[]{usageContext, configUri, this.configuration.getHasFolderToCrawl()}));
        }
        String folder = (String)foldersToCrawl.get(0);
        if (new HashSet(foldersToCrawl).size() > 1) {
            this.logger.warn((Object)Messages.getString((String)"FolderResourceC.WARN.MoreThanOneFolder", (Object[])new Object[]{usageContext, configUri, this.configuration.getHasFolderToCrawl(), folder}));
        }
        return folder;
    }

    public static File checkFolder(String path, String usageContext) throws AccessDeniedException {
        File f = new File(path);
        if (!f.exists()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceC.ERROR.FolderNotExist", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        if (!f.isDirectory()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceC.ERROR.FileNotDirectory", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        if (!f.canRead()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceC.ERROR.FileNotReadable", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        return f;
    }
}

