/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.iterator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.services.iterator.messages.Messages;

public class InterfacesMappingSingleton {
    private static InterfacesMappingSingleton SINGLETON = null;
    private final Map<String, Iterator<?>> iteratorByUsageContext;
    private final Log logger = LogFactory.getLog(this.getClass());

    public static synchronized InterfacesMappingSingleton getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new InterfacesMappingSingleton();
        }
        return SINGLETON;
    }

    private InterfacesMappingSingleton() {
        this.iteratorByUsageContext = Collections.synchronizedMap(new HashMap());
        this.logger.info((Object)Messages.getString((String)"InterfacesMappingSingleton.INFO.Initialised"));
    }

    public synchronized Iterator<?> addToMap(String usageContext, Iterator<?> fileIterator) {
        this.logger.debug((Object)("Add iterator for usageContext '" + usageContext + "'."));
        return this.iteratorByUsageContext.put(usageContext, fileIterator);
    }

    public synchronized void clearMap() {
        this.logger.debug((Object)"Start emptying the map.");
        for (Map.Entry entry : this.iteratorByUsageContext.entrySet()) {
            Iterator it = (Iterator)entry.getValue();
            while (it.hasNext()) {
                it.next();
            }
        }
        this.iteratorByUsageContext.clear();
        this.logger.debug((Object)"Map emptied.");
    }

    public synchronized Iterator<?> getIterator(String usageContext) {
        this.logger.debug((Object)("Retrieve iterator for usageContext '" + usageContext + "'."));
        return (Iterator)this.iteratorByUsageContext.get(usageContext);
    }

    public synchronized boolean isConfigured(String usageContext) {
        return this.iteratorByUsageContext.containsKey(usageContext);
    }

    public synchronized void removeConfiguration(String usageContext) {
        if (this.iteratorByUsageContext.containsKey(usageContext)) {
            this.logger.debug((Object)("Remove iterator for usageContext '" + usageContext + "'."));
            Iterator it = (Iterator)this.iteratorByUsageContext.remove(usageContext);
            while (it.hasNext()) {
                it.next();
            }
        } else {
            this.logger.debug((Object)("Nothing to remove for usageContext '" + usageContext + "'."));
        }
    }
}

