/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.iterator;

import org.apache.commons.io.filefilter.IOFileFilter;


/**
 * This class is a bean holder for the configuration of FolderResourceQM and FolderResourceConf.
 * It is needed as parameter of their constructor.
 * 
 * @author ymombrun
 * @date 2011-08-17
 */
public class ConfigurationBean {


	// Default constants fields.

	/**
	 * Default namespace of the configuration ontology used here.
	 */
	public final static String DEFAULT_CONF_ONTO = "http://weblab.ow2.org/core/1.2/ontology/configuration#";


	/**
	 * Default URI of the Configuration type.
	 */
	public static final String DEFAULT_CONF_TYPE = ConfigurationBean.DEFAULT_CONF_ONTO + "Configuration";


	/**
	 * Default property that links a service URI with an instance of configuration.
	 */
	public static final String DEFAULT_HAS_CONFIGURATION_URI = ConfigurationBean.DEFAULT_CONF_ONTO + "hasConfiguration";


	/**
	 * Default property that links an instance of configuration with is folder to crawl.
	 */
	public static final String DEFAULT_HAS_FOLDER_TO_CRAWL = ConfigurationBean.DEFAULT_CONF_ONTO + "hasFolderToCrawl";


	/**
	 * Default property that links an instance of configuration with its usageContext.
	 */
	public static final String DEFAULT_IS_LINKED_TO_CONTEXT = ConfigurationBean.DEFAULT_CONF_ONTO + "isLinkedToContext";


	/**
	 * The default service URI
	 */
	public static final String DEFAULT_SERVICE_URI = "http://weblab.ow2.org/services/folder-resource-iterator";



	/**
	 * The URI of the RDF type for an instance of configuration.
	 * 
	 * Default value is {@value #DEFAULT_CONF_TYPE}.
	 */
	protected String configurationType = ConfigurationBean.DEFAULT_CONF_TYPE;


	/**
	 * The default path to be used by null or empty usageContext.
	 * 
	 * Default value is <code>null</code>.
	 */
	protected String defaultPath = null;


	/**
	 * The filter to be applied on each directory found while iterating.
	 */
	protected IOFileFilter directoryFilter;


	/**
	 * The filter to be applied on each file found while iterating.
	 */
	protected IOFileFilter fileFilter;


	/**
	 * The URI of the property that links a service URI with an instance of configuration.
	 * 
	 * Default value is {@value #DEFAULT_HAS_CONFIGURATION_URI}.
	 */
	protected String hasConfiguration = ConfigurationBean.DEFAULT_HAS_CONFIGURATION_URI;


	/**
	 * The URI of the property that links an instance of configuration with the folder to crawl.
	 * 
	 * Default value is {@value #DEFAULT_HAS_FOLDER_TO_CRAWL}.
	 */
	protected String hasFolderToCrawl = ConfigurationBean.DEFAULT_HAS_FOLDER_TO_CRAWL;


	/**
	 * The URI of the property that links an instance of configuration with it's usageContext.
	 * 
	 * Default value is {@value #DEFAULT_IS_LINKED_TO_CONTEXT}.
	 */
	protected String isLinkedToContext = ConfigurationBean.DEFAULT_IS_LINKED_TO_CONTEXT;


	/**
	 * Whether to remove files after accessing them from the iterator. Please not that this is discouraged since it can lead to FileNotFoundException if two
	 * iterator are working on the same folder.
	 * 
	 * Default value is <code>false</code>.
	 */
	protected boolean removeFiles = false;


	/**
	 * The URI of the service.
	 * 
	 * Default value is {@value #DEFAULT_SERVICE_URI}.
	 */
	protected String serviceUri = ConfigurationBean.DEFAULT_SERVICE_URI;


	/**
	 * Whether the defaultPath should also be used by unknown usageContexts, instead of throwing a ServiceNotConfiguredException.
	 * 
	 * Default value is <code>false</code>.
	 */
	protected boolean useDefaultPathForNotConfigured = false;


	/**
	 * @return the configurationType
	 */
	public String getConfigurationType() {
		return this.configurationType;
	}


	/**
	 * @return The default path
	 */
	public String getDefaultFolder() {
		return this.defaultPath;
	}


	/**
	 * @return the defaultPath
	 */
	public String getDefaultPath() {
		return this.defaultPath;
	}


	/**
	 * @return the directoryFilter
	 */
	public IOFileFilter getDirectoryFilter() {
		return this.directoryFilter;
	}


	/**
	 * @return the fileFilter
	 */
	public IOFileFilter getFileFilter() {
		return this.fileFilter;
	}


	/**
	 * @return the hasConfiguration
	 */
	public String getHasConfiguration() {
		return this.hasConfiguration;
	}


	/**
	 * @return the hasFolderToCrawl
	 */
	public String getHasFolderToCrawl() {
		return this.hasFolderToCrawl;
	}


	/**
	 * @return the isLinkedToContext
	 */
	public String getIsLinkedToContext() {
		return this.isLinkedToContext;
	}


	/**
	 * @return the serviceUri
	 */
	public String getServiceUri() {
		return this.serviceUri;
	}


	/**
	 * @return the removeFiles
	 */
	public boolean isRemoveFiles() {
		return this.removeFiles;
	}


	/**
	 * @return the useDefaultPathForNotConfigured
	 */
	public boolean isUseDefaultPathForNotConfigured() {
		return this.useDefaultPathForNotConfigured;
	}


	/**
	 * @param configurationType
	 *            the configurationType to set
	 */
	public void setConfigurationType(final String configurationType) {
		this.configurationType = configurationType;
	}


	/**
	 * @param defaultPath
	 *            the defaultPath to set
	 */
	public void setDefaultPath(final String defaultPath) {
		this.defaultPath = defaultPath;
	}


	/**
	 * @param directoryFilter
	 *            the directoryFilter to set
	 */
	public void setDirectoryFilter(final IOFileFilter directoryFilter) {
		this.directoryFilter = directoryFilter;
	}


	/**
	 * @param fileFilter
	 *            the fileFilter to set
	 */
	public void setFileFilter(final IOFileFilter fileFilter) {
		this.fileFilter = fileFilter;
	}


	/**
	 * @param hasConfiguration
	 *            the hasConfiguration to set
	 */
	public void setHasConfiguration(final String hasConfiguration) {
		this.hasConfiguration = hasConfiguration;
	}


	/**
	 * @param hasFolderToCrawl
	 *            the hasFolderToCrawl to set
	 */
	public void setHasFolderToCrawl(final String hasFolderToCrawl) {
		this.hasFolderToCrawl = hasFolderToCrawl;
	}


	/**
	 * @param isLinkedToContext
	 *            the isLinkedToContext to set
	 */
	public void setIsLinkedToContext(final String isLinkedToContext) {
		this.isLinkedToContext = isLinkedToContext;
	}


	/**
	 * @param removeFiles
	 *            the removeFiles to set
	 */
	public void setRemoveFiles(final boolean removeFiles) {
		this.removeFiles = removeFiles;
	}


	/**
	 * @param serviceUri
	 *            the serviceUri to set
	 */
	public void setServiceUri(final String serviceUri) {
		this.serviceUri = serviceUri;
	}


	/**
	 * @param useDefaultPathForNotConfigured
	 *            the useDefaultPathForNotConfigured to set
	 */
	public void setUseDefaultPathForNotConfigured(final boolean useDefaultPathForNotConfigured) {
		this.useDefaultPathForNotConfigured = useDefaultPathForNotConfigured;
	}


	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("ConfigurationBean [defaultPath=");
		builder.append(this.defaultPath);
		builder.append(", useDefaultPathForNotConfigured=");
		builder.append(this.useDefaultPathForNotConfigured);
		builder.append(", removeFiles=");
		builder.append(this.removeFiles);
		builder.append("]");
		return builder.toString();
	}

}
