/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.iterator;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.EmptyQueueException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.QueueManager;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.queuemanager.NextResourceArgs;
import org.ow2.weblab.core.services.queuemanager.NextResourceReturn;
import org.ow2.weblab.services.iterator.ConfigurationBean;
import org.ow2.weblab.services.iterator.FolderResourceConf;
import org.ow2.weblab.services.iterator.InterfacesMappingSingleton;
import org.ow2.weblab.services.iterator.messages.Messages;

public class FolderResourceQM
implements QueueManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ConfigurationBean configuration;
    protected final InterfacesMappingSingleton mapping;
    protected final WebLabMarshaller marshaller;

    public FolderResourceQM(ConfigurationBean configuration) throws UnexpectedException, AccessDeniedException {
        this.configuration = configuration;
        this.mapping = InterfacesMappingSingleton.getInstance();
        if (this.configuration.useDefaultPathForNotConfigured) {
            this.configureWithDefault("");
        }
        this.marshaller = new WebLabMarshaller();
        this.logger.info((Object)Messages.getString((String)"FolderResourceQM.INFO.Started", (Object[])new Object[]{this.configuration.toString()}));
    }

    public NextResourceReturn nextResource(NextResourceArgs args) throws EmptyQueueException, UnexpectedException, InvalidParameterException, ServiceNotConfiguredException, AccessDeniedException {
        Resource res;
        this.logger.debug((Object)"Early start of nextResource Method");
        String usageContext = this.checkNextResourceArgs(args);
        this.logger.info((Object)Messages.getString((String)"FolderResourceQM.INFO.NextResourceCalled", (Object[])new Object[]{usageContext}));
        File f = this.getFile(usageContext);
        this.logger.debug((Object)("Try unmarshall file '" + f.getAbsolutePath() + "' for usageContext '" + usageContext + "'."));
        try {
            res = this.marshaller.unmarshal(f, Resource.class);
        }
        catch (WebLabCheckedException wlce) {
            throw new UnexpectedException(Messages.getString((String)"FolderResourceQM.ERROR.UnmarshalError", (Object[])new Object[]{usageContext, f.getPath()}), (Throwable)wlce);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)ResourceUtil.saveToXMLString((Resource)res));
            }
            catch (WebLabCheckedException wlce) {
                this.logger.warn((Object)Messages.getString((String)"FolderResourceQM.WARNING.MarshalError", (Object[])new Object[]{usageContext, f.getPath(), res.getUri()}), (Throwable)wlce);
            }
        }
        if (this.configuration.isRemoveFiles()) {
            this.logger.debug((Object)("Try remove file '" + f.getAbsolutePath() + "' for usageContext '" + usageContext + "'."));
            FileUtils.deleteQuietly((File)f);
        }
        NextResourceReturn nrr = new NextResourceReturn();
        nrr.setResource(res);
        return nrr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(String usageContext) throws ServiceNotConfiguredException, EmptyQueueException, UnexpectedException, AccessDeniedException {
        File f;
        InterfacesMappingSingleton interfacesMappingSingleton = this.mapping;
        synchronized (interfacesMappingSingleton) {
            Iterator it = this.mapping.getIterator(usageContext);
            if (it == null) {
                throw new ServiceNotConfiguredException(Messages.getString((String)"FolderResourceQM.ERROR.NotConfigured", (Object[])new Object[]{usageContext}));
            }
            if (!it.hasNext()) {
                this.logger.debug((Object)("No more resource in iterator for usageContext '" + usageContext + "'."));
                throw new EmptyQueueException(Messages.getString((String)"FolderResourceQM.ERROR.Empty", (Object[])new Object[]{usageContext}));
            }
            Object o = it.next();
            if (!(o instanceof File)) {
                throw new UnexpectedException(Messages.getString((String)"FolderResourceQM.ERROR.NotAFile", (Object[])new Object[]{usageContext, o}));
            }
            f = (File)o;
        }
        if (!f.exists()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceQM.ERROR.FileNotExist", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        if (!f.isFile()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceQM.ERROR.FileNotFile", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        if (!f.canRead()) {
            throw new AccessDeniedException(Messages.getString((String)"FolderResourceQM.ERROR.FileNotReadable", (Object[])new Object[]{usageContext, f.getPath()}));
        }
        return f;
    }

    private String checkNextResourceArgs(NextResourceArgs args) throws InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, AccessDeniedException {
        if (args == null) {
            throw new InvalidParameterException(Messages.getString((String)"FolderResourceQM.ERROR.ArgsNull"));
        }
        String uc = args.getUsageContext();
        if (uc == null) {
            this.logger.debug((Object)"UsageContext was null, use the empty string.");
            uc = "";
        }
        if (!this.mapping.isConfigured(uc) && this.configuration.isUseDefaultPathForNotConfigured()) {
            this.configureWithDefault(uc);
        } else if (!this.mapping.isConfigured(uc)) {
            throw new ServiceNotConfiguredException(Messages.getString((String)"FolderResourceQM.ERROR.NotConfigured", (Object[])new Object[]{uc}));
        }
        return uc;
    }

    private synchronized void configureWithDefault(String uc) throws UnexpectedException, AccessDeniedException {
        String folder = this.configuration.getDefaultFolder();
        if (folder == null) {
            throw new UnexpectedException(Messages.getString((String)"FolderResourceQM.ERROR.PathNull", (Object[])new Object[]{uc}));
        }
        File f = FolderResourceConf.checkFolder((String)folder, (String)uc);
        Iterator it = FileUtils.iterateFiles((File)f, (IOFileFilter)this.configuration.getFileFilter(), (IOFileFilter)this.configuration.getDirectoryFilter());
        this.mapping.addToMap(uc, it);
    }
}

