/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.services.Configurable;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.configurable.ConfigureArgs;
import org.ow2.weblab.core.services.configurable.ConfigureReturn;
import org.ow2.weblab.core.services.configurable.ResetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.ResetConfigurationReturn;
import org.ow2.weblab.service.gate.Configuration;

@WebService(endpointInterface="org.ow2.weblab.core.services.Configurable")
public class GateConfiguratorService
implements Configurable {
    public static final String DEFAULT_SERVICE_URI = "http://weblab.ow2.org/webservices/gateservice";
    public static final String GAPP_FILE_PATH_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/processing#gate/gappFilePath";
    private final String serviceURI;
    private final Log logger = LogFactory.getLog(this.getClass());

    public GateConfiguratorService() {
        this(DEFAULT_SERVICE_URI);
    }

    public GateConfiguratorService(String serviceURI) {
        this.serviceURI = serviceURI;
    }

    public ConfigureReturn configure(ConfigureArgs args) throws InvalidParameterException {
        this.logger.info((Object)"Configure method called.");
        PoKHelper helper = this.checkArgs(args);
        List gappFilePaths = helper.getLitsOnPredSubj(this.serviceURI, GAPP_FILE_PATH_PROPERTY);
        if (gappFilePaths.isEmpty()) {
            String exceptionMessage = "PieceOfKnowledge of used for configuration does not contains required statement: (S,P,O) = ('" + this.serviceURI + "', '" + GAPP_FILE_PATH_PROPERTY + "', PathToGappFile)";
            throw new InvalidParameterException(exceptionMessage, exceptionMessage);
        }
        String gappFilePath = (String)gappFilePaths.get(0);
        if (gappFilePaths.size() > 1) {
            this.logger.warn((Object)("More than one statement (S,P,O) = ('" + this.serviceURI + "', '" + GAPP_FILE_PATH_PROPERTY + "', PathToGappFile) found in configuration pok."));
        }
        this.checkFile(gappFilePath);
        Configuration.getInstance().setGateApplicationStateFileName(args.getUsageContext(), gappFilePath);
        this.logger.info((Object)("GappFile affected : " + gappFilePath));
        return new ConfigureReturn();
    }

    private void checkFile(String gappFilePath) throws InvalidParameterException {
        File file = new File(gappFilePath);
        if (!file.exists()) {
            throw new InvalidParameterException("GappFile '" + file.getAbsolutePath() + "' does not exists.", "GappFile '" + file.getAbsolutePath() + "' does not exists.");
        }
        if (!file.isFile()) {
            throw new InvalidParameterException("GappFile '" + file.getAbsolutePath() + "' is not a file.", "GappFile '" + file.getAbsolutePath() + "' does not exists.");
        }
        if (!file.canRead()) {
            throw new InvalidParameterException("GappFile '" + file.getAbsolutePath() + "' cannot be read.", "GappFile '" + file.getAbsolutePath() + "' does not exists.");
        }
    }

    private PoKHelper checkArgs(ConfigureArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("ConfigureArgs was null", "ConfigureArgs was null");
        }
        if (args.getUsageContext() == null) {
            throw new InvalidParameterException("UsageContext was null", "UsageContext was null");
        }
        if (args.getConfiguration() == null) {
            throw new InvalidParameterException("Configuration was null", "Configuration was null");
        }
        return new JenaPoKHelper(args.getConfiguration());
    }

    public ResetConfigurationReturn resetConfiguration(ResetConfigurationArgs args) throws InvalidParameterException {
        this.logger.info((Object)"ResetConfiguration method called.");
        if (args == null || args.getUsageContext() == null || args.getUsageContext() == null) {
            throw new InvalidParameterException("ResetConfigurationArgs was invalid (either it self, usageContext, it's uri or configuration was null", "ResetConfigurationArgs was invalid (either it self, usageContext, it's uri or configuration was null");
        }
        Configuration.getInstance().resetConfiguration(args.getUsageContext());
        return new ResetConfigurationReturn();
    }
}

