/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate.converter;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.comparator.SegmentComparator;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.SegmentFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.extended.util.TextUtil;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.service.gate.converter.GateConverter;

public class GateToWookie
implements GateConverter {
    private String serviceURI;
    private static final String WOOKIE_URI = "http://weblab.ow2.org/wookie#";
    private static final String INSTANCE_URI_PREFIX = "http://weblab.ow2.org/wookie/instances/";

    public void convertInformation(Corpus corpusGate, Resource resource, Map<Document, Text> gateDocsAndText) {
        Iterator<Map.Entry<Document, Text>> it = gateDocsAndText.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Document, Text> entry = it.next();
            this.linkGateAnnotsToText(entry.getValue(), entry.getKey().getAnnotations());
            if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
                LogFactory.getLog(this.getClass()).debug((Object)("Number of segment after GateExtractionComponent: " + entry.getValue().getSegment().size()));
                try {
                    LogFactory.getLog(this.getClass()).debug((Object)ResourceUtil.saveToXMLString((Resource)((Resource)entry.getValue())));
                }
                catch (WebLabCheckedException wlce) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Unable to serialise to XML the resource: '" + entry.getValue().getUri() + "'."), (Throwable)wlce);
                }
            }
            corpusGate.unloadDocument(entry.getKey());
            Factory.deleteResource((gate.Resource)((gate.Resource)entry.getKey()));
            it.remove();
        }
        gateDocsAndText.clear();
        Factory.deleteResource((gate.Resource)corpusGate);
    }

    private void linkGateAnnotsToText(Text text, AnnotationSet annots) {
        int nbAnnots = 0;
        org.ow2.weblab.core.model.Annotation wlAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)text);
        JenaPoKHelper pokhe = new JenaPoKHelper((PieceOfKnowledge)wlAnnot);
        pokhe.setAutoCommitMode(false);
        pokhe.setNSPrefix("wlp", "http://weblab.ow2.org/core/1.2/ontology/processing#");
        pokhe.setNSPrefix("wookie", WOOKIE_URI);
        if (this.serviceURI != null) {
            pokhe.createResStat(wlAnnot.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#isProducedBy", this.serviceURI);
        }
        if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
            LogFactory.getLog(this.getClass()).debug((Object)("Gate Annotation set: " + annots));
        }
        for (Annotation gateAnnot : annots) {
            if (gateAnnot.getType().equals("Person")) {
                this.linkGateAnnotToText(text, gateAnnot, (PoKHelper)pokhe, "Person");
                ++nbAnnots;
                continue;
            }
            if (gateAnnot.getType().equals("Organization")) {
                this.linkGateAnnotToText(text, gateAnnot, (PoKHelper)pokhe, "Unit");
                ++nbAnnots;
                continue;
            }
            if (!gateAnnot.getType().equals("Location")) continue;
            this.linkGateAnnotToText(text, gateAnnot, (PoKHelper)pokhe, "Place");
            ++nbAnnots;
        }
        if (nbAnnots > 0) {
            try {
                pokhe.commit();
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)("Unable to serialise RDF model for text '" + text.getUri() + "'."), (Throwable)e);
                LogFactory.getLog(this.getClass()).debug((Object)annots);
            }
            Collections.sort(text.getSegment(), new SegmentComparator());
        } else {
            text.getAnnotation().remove(wlAnnot);
        }
    }

    private void linkGateAnnotToText(Text text, Annotation annotGate, PoKHelper pokh, String annotWookieType) {
        String label;
        LinearSegment segment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)annotGate.getStartNode().getOffset().intValue(), (int)annotGate.getEndNode().getOffset().intValue());
        String instanceURI = INSTANCE_URI_PREFIX + annotWookieType + '#' + System.nanoTime();
        String typeURI = WOOKIE_URI + annotWookieType;
        try {
            label = TextUtil.getSegmentText((Text)text, (LinearSegment)segment);
            instanceURI = this.getUriFromLabel(INSTANCE_URI_PREFIX + annotWookieType + '#', label);
        }
        catch (WebLabCheckedException wlce) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to retrieve text at segment: " + segment.getUri() + " - " + segment.getStart() + " - " + segment.getEnd() + ". Removing it."), (Throwable)wlce);
            text.getSegment().remove(segment);
            return;
        }
        pokh.createResStat(instanceURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeURI);
        pokh.createResStat(segment.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo", instanceURI);
        if (!label.trim().isEmpty()) {
            pokh.createLitStat(instanceURI, "http://www.w3.org/2000/01/rdf-schema#label", label.trim());
        }
    }

    public void setServiceURI(String serviceURI) {
        if (serviceURI != null && !serviceURI.isEmpty()) {
            this.serviceURI = serviceURI;
        }
    }

    private String getUriFromLabel(String baseUri, String label) {
        String uri = baseUri + System.nanoTime();
        try {
            String cleanedName = label.replace('(', ' ').replace(' ', ' ').replace(')', ' ').replace('\u00b0', ' ').replace('$', ' ').replace('/', ' ').replace('\\', ' ').replace('#', ' ').replace('\'', ' ').replace('.', ' ').replace(',', ' ').replace('?', ' ').replace('!', ' ').replace('@', ' ').replaceAll("\\s+", " ").trim().replace(' ', '_').toLowerCase();
            uri = new URL(baseUri + cleanedName).toURI().toString();
        }
        catch (URISyntaxException urise) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to use label '" + label + "' to generate an uri. Generate a generic URI (" + uri + ")."), (Throwable)urise);
        }
        catch (MalformedURLException murle) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to use label '" + label + "' to generate an uri. Generate a generic URI (" + uri + ")."), (Throwable)murle);
        }
        return uri;
    }
}

