/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.exposer;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.JenaSingleResourceHelper;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.service.exposer.config.ExposerConfigBean;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class LocalFileExposer
implements Analyser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ExposerConfigBean conf;

    public LocalFileExposer(ExposerConfigBean configuration) {
        this.conf = configuration;
        this.logger.info((Object)"LocalFileExposer successfully started.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessReturn process(ProcessArgs args) throws UnexpectedException, InvalidParameterException {
        String tempSource;
        this.logger.debug((Object)"Early start of process method.");
        Document doc = this.checkArgs(args);
        this.logger.info((Object)("Start processing document " + doc.getUri() + "."));
        JenaSingleResourceHelper rh = new JenaSingleResourceHelper((Resource)doc);
        HashSet sources = this.conf.isSourceIsResource() ? new HashSet(rh.getRessOnPredSubj(doc.getUri(), this.conf.getSourceUri())) : new HashSet(rh.getLitsOnPredSubj(doc.getUri(), this.conf.getSourceUri()));
        Iterator sourceIt = sources.iterator();
        if (!sourceIt.hasNext()) {
            this.logger.warn((Object)("No '" + this.conf.getSourceUri() + "' property found in resource '" + doc.getUri() + "'. Nothing is done."));
            ProcessReturn pr = new ProcessReturn();
            pr.setResource((Resource)doc);
            return pr;
        }
        String originalSource = (String)sourceIt.next();
        if (sourceIt.hasNext()) {
            this.logger.warn((Object)("More than one value found for property '" + this.conf.getSourceUri() + "' in resource '" + doc.getUri() + "'."));
            this.logger.debug((Object)("Values found were '" + sources + "'."));
            this.logger.debug((Object)("'" + originalSource + "' will be used."));
        }
        StringBuilder finalSource = new StringBuilder();
        if (this.conf.getNbStartCharToReplace() > 1) {
            if (originalSource.length() <= this.conf.getNbStartCharToReplace()) {
                this.logger.warn((Object)("Source found (" + originalSource + ") is smaller than the number of character to replace (" + String.valueOf(this.conf.getNbStartCharToReplace()) + "). Nothing is done."));
                ProcessReturn pr = new ProcessReturn();
                pr.setResource((Resource)doc);
                return pr;
            }
            finalSource.append(this.conf.getByString());
            tempSource = originalSource.substring(this.conf.getNbStartCharToReplace());
        } else {
            this.logger.debug((Object)"nbStartCharToReplace is smaller that one; no replacement is done.");
            tempSource = originalSource;
        }
        tempSource = tempSource.replace('\\', '/');
        if (this.conf.isUrlEncodeBetweenSlashes()) {
            try {
                String[] splitted;
                for (String element : splitted = tempSource.split("/")) {
                    finalSource.append("/");
                    finalSource.append(URLEncoder.encode(element, this.conf.getUrlEncoding()));
                }
            }
            catch (UnsupportedEncodingException uee) {
                this.logger.fatal((Object)(this.conf.getUrlEncoding() + " is not supported. Check configuration file."), (Throwable)uee);
                throw new UnexpectedException(this.conf.getUrlEncoding() + " is not supported. Check configuration file.", (Throwable)uee);
            }
        }
        String exposedAs = finalSource.toString().replace("+", this.conf.getReplacementForSpace());
        Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)doc);
        JenaPoKHelper pokH = new JenaPoKHelper((PieceOfKnowledge)annot, false);
        if (this.conf.isAnnotateAsUri()) {
            pokH.createResStat(doc.getUri(), this.conf.getExposedAsUri(), exposedAs);
        } else {
            pokH.createLitStat(doc.getUri(), this.conf.getExposedAsUri(), exposedAs);
        }
        if (this.conf.getServiceUri() != null) {
            pokH.createResStat(annot.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#isProducedBy", this.conf.getServiceUri());
        }
        pokH.commit();
        ProcessReturn pr = new ProcessReturn();
        pr.setResource((Resource)doc);
        return pr;
    }

    private Document checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("ProcessArgs is null");
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new InvalidParameterException("Resource is null");
        }
        if (!(res instanceof Document)) {
            throw new InvalidParameterException("Resource was not a Document but a: " + args.getResource().getClass().getName());
        }
        if (!args.getResource().isSetAnnotation()) {
            throw new InvalidParameterException("Document does not contains any Annotation.");
        }
        return (Document)args.getResource();
    }
}

