package org.ow2.weblab.service.translate;

import java.io.IOException;

public interface Translator {
	/**
	 * Return the translated language code using ISO 639-1.
	 * 
	 * @return the translated language
	 */
	public String getLangCode();

	/**
	 * Translate into another language.
	 * 
	 * @param toBeTranslated
	 *            the String to be translated in
	 * @return the translated String
	 * @throws IOException
	 *             something wrong during the translation
	 */
	public String translate(String toBeTranslated) throws IOException;

}
