/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.translate.moses;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.service.translate.Translator;

public class MosesTranslator
implements Translator {
    protected String escapedRegExp;
    public static final String DEFAULT_ESCAPED_REG_EXP = "\\p{Punct}";
    protected String langCode;
    protected String mosesIniPath;
    protected BufferedReader br;
    protected BufferedWriter bw;
    protected static Log LOGGER = LogFactory.getLog(MosesTranslator.class);

    public MosesTranslator(String mosesIniPath, String langCode, String escapedRegExp) throws IOException {
        this.mosesIniPath = mosesIniPath;
        this.langCode = langCode;
        this.escapedRegExp = escapedRegExp;
        LOGGER.trace((Object)("Initializing: " + this));
        this.launchCommand();
    }

    public String toString() {
        return this.mosesIniPath + " for target language " + this.langCode + " escaping " + this.escapedRegExp;
    }

    public MosesTranslator(String mosesIniPath, String langCode) throws IOException {
        this(mosesIniPath, langCode, DEFAULT_ESCAPED_REG_EXP);
    }

    protected void launchCommand() throws IOException {
        Process process = null;
        this.br = null;
        this.bw = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("moses");
        command.add("-f");
        command.add(this.mosesIniPath);
        LOGGER.info((Object)("Trying to launch command line: moses -f " + this.mosesIniPath));
        ProcessBuilder builder = new ProcessBuilder(command);
        process = builder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        this.br = new BufferedReader(isr);
        this.bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        LOGGER.debug((Object)("Testing translation (testing): " + this.translate("testing")));
    }

    public synchronized String translate(String toBeTranslated) throws IOException {
        toBeTranslated = this.cleanString(toBeTranslated);
        LOGGER.debug((Object)("Translation of: " + toBeTranslated));
        this.bw.append(toBeTranslated.toLowerCase());
        this.bw.newLine();
        this.bw.flush();
        String result = this.br.readLine();
        LOGGER.debug((Object)("into: " + result + "\nFinished."));
        if (result == null) {
            result = toBeTranslated;
        }
        return result.trim();
    }

    protected String cleanString(String toBeCleaned) {
        return toBeCleaned.replaceAll(this.escapedRegExp, " ");
    }

    public String getLangCode() {
        return this.langCode;
    }
}

