/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.translate.moses;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.comparator.SegmentComparator;
import org.ow2.weblab.core.extended.factory.MediaUnitFactory;
import org.ow2.weblab.core.extended.factory.SegmentFactory;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.rdf.Value;
import org.ow2.weblab.service.translate.Translator;
import org.ow2.weblab.service.translate.moses.MosesTranslator;
import org.purl.dc.elements.DublinCoreAnnotator;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class MosesTranslatorService
implements Analyser {
    protected boolean alignSegment = false;
    protected String splitRegexp = "[\\.|?|!\\n]";
    protected static Map<String, Translator> TRANSLATORS;
    static Pattern CONFIG_LANG_MODEL_PATTERN;
    protected static Log LOG;

    public void init(String configFile) throws IOException {
        Map props = PropertiesLoader.loadProperties((String)configFile);
        TRANSLATORS = Collections.synchronizedMap(new HashMap());
        for (Map.Entry entry : props.entrySet()) {
            if ("align-segment".equals(entry.getKey())) {
                this.alignSegment = Boolean.parseBoolean((String)entry.getValue());
                LOG.debug((Object)("Setting align segment to " + this.alignSegment));
                continue;
            }
            if ("sentence-regexp".equals(entry.getKey())) {
                this.splitRegexp = (String)entry.getValue();
                LOG.debug((Object)("Setting regexp used to slipt between sentences to " + this.splitRegexp));
                continue;
            }
            Matcher m = CONFIG_LANG_MODEL_PATTERN.matcher((CharSequence)entry.getKey());
            if (m.matches()) {
                try {
                    String[] values = ((String)entry.getValue()).split(",");
                    if (values.length == 1) {
                        TRANSLATORS.put(m.group(1), new MosesTranslator(values[0], m.group(2)));
                        continue;
                    }
                    if (values.length == 2) {
                        TRANSLATORS.put(m.group(1), new MosesTranslator(values[0], m.group(2), values[1].trim()));
                        continue;
                    }
                    String errorMsg = "Bad value " + (String)entry.getValue() + " for entry " + (String)entry.getKey() + " inside " + configFile + " moses configuration file.";
                    LOG.trace((Object)errorMsg);
                    throw new IOException(errorMsg);
                }
                catch (IOException e) {
                    LOG.error((Object)("Error during initialisation of moses translator from file: " + (String)entry.getValue() + " for languages couple: " + (String)entry.getKey()), (Throwable)e);
                    throw e;
                }
            }
            LOG.warn((Object)("Skipping unknowed property: " + (String)entry.getKey()));
        }
    }

    @PostConstruct
    public void init() throws IOException {
        this.init("moses_config.properties");
    }

    public ProcessReturn process(ProcessArgs processArgs) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        this.checkArgs(processArgs);
        Document document = (Document)processArgs.getResource();
        List texts = ResourceUtil.getSelectedSubResources((Resource)document, Text.class);
        if (texts != null && texts.size() > 0) {
            long start = 0L;
            if (LOG.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            for (Text text : texts) {
                this.translate(text, document);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Translation duration :" + (System.currentTimeMillis() - start) + "ms"));
            }
            LOG.info((Object)("Document [" + processArgs.getResource().getUri() + "]: translation done."));
        }
        ProcessReturn ret = new ProcessReturn();
        ret.setResource(processArgs.getResource());
        return ret;
    }

    private void translate(Text text, Document parent) {
        DublinCoreAnnotator dublinCoreAnnotator = new DublinCoreAnnotator((Resource)text);
        Value languageVal = dublinCoreAnnotator.readLanguage();
        if (languageVal != null && languageVal.hasValue()) {
            String language = (String)languageVal.firstTypedValue();
            Translator translator = (Translator)TRANSLATORS.get(language);
            if (translator != null) {
                try {
                    StringBuffer translatedBuffer = new StringBuffer();
                    Text translatedTextUnit = (Text)MediaUnitFactory.createAndLinkMediaUnit((Document)parent, Text.class);
                    WProcessingAnnotator wProcessingAnnotator = new WProcessingAnnotator((Resource)translatedTextUnit);
                    wProcessingAnnotator.writeTranslationOf(new URI(text.getUri()));
                    int mainIndex = 0;
                    for (String trans : text.getContent().split(this.splitRegexp)) {
                        if ((trans = trans.trim()).length() <= 0) continue;
                        String curTranslation = translator.translate(trans);
                        if (this.alignSegment) {
                            mainIndex = text.getContent().indexOf(trans, mainIndex);
                            int translatedIndex = translatedBuffer.length();
                            LinearSegment mainLinearSegment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)mainIndex, (int)(mainIndex + trans.length()));
                            LinearSegment translatedLinearSegment = SegmentFactory.createAndLinkLinearSegment((Text)translatedTextUnit, (int)translatedIndex, (int)(translatedIndex + curTranslation.length()));
                            wProcessingAnnotator.startInnerAnnotatorOn(new URI(translatedLinearSegment.getUri()));
                            wProcessingAnnotator.writeTranslationOf(new URI(mainLinearSegment.getUri()));
                        }
                        translatedBuffer.append(curTranslation + "\n");
                        mainIndex += trans.length();
                    }
                    String translatedText = translatedBuffer.toString();
                    translatedTextUnit.setContent(translatedText);
                    DublinCoreAnnotator coreAnnotator = new DublinCoreAnnotator((Resource)translatedTextUnit);
                    coreAnnotator.writeLanguage(translator.getLangCode());
                    Collections.sort(text.getSegment(), new SegmentComparator());
                    Collections.sort(translatedTextUnit.getSegment(), new SegmentComparator());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error during translation of " + text.getUri() + " with identified language: <" + language + "> skipping text unit."));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Text content which failed to translate: " + text.getContent()));
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error((Object)("UNABLE TO TRANSFORM WLURI:" + text.getUri() + "to URI"));
                }
            } else {
                LOG.warn((Object)("No translator defined for <" + language + "> skipping text unit."));
            }
        } else {
            LOG.warn((Object)("No language identified on <" + text.getUri() + "> skipping text unit."));
        }
    }

    private void checkArgs(ProcessArgs processArg) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        if (processArg == null) {
            throw new InvalidParameterException("ProcessArgs was null.", "ProcessArgs was null.");
        }
        Resource res = processArg.getResource();
        if (res == null) {
            throw new InsufficientResourcesException("Resource in ProcessArgs was null.", "Resource in ProcessArgs was null.");
        }
        if (!(res instanceof Document)) {
            throw new InvalidParameterException("Resource in ProcessArgs was not an instance of Document but of [" + res.getClass().getCanonicalName() + "].", "");
        }
    }

    static {
        CONFIG_LANG_MODEL_PATTERN = Pattern.compile("(\\w{2,3})-(\\w{2,3})-model");
        LOG = LogFactory.getLog(MosesTranslatorService.class);
    }
}

