/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.PoKUtil;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Configurable;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.configurable.ConfigureArgs;
import org.ow2.weblab.core.services.configurable.ConfigureReturn;
import org.ow2.weblab.core.services.configurable.GetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.GetConfigurationReturn;
import org.ow2.weblab.core.services.configurable.ResetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.ResetConfigurationReturn;
import org.ow2.weblab.service.searchconnector.backend.SearchConnector;
import org.ow2.weblab.service.searchconnector.backend.opensearch.OSearchConnector;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.ow2.weblab.core.services.Configurable")
public class SearchConnectorConfigurable
implements Configurable {
    public static final String ERROR = "This is bad man... we cannot serve the request.";
    private final Log logger = LogFactory.getLog(this.getClass());

    public SearchConnectorConfigurable() {
        this.logger.info((Object)"Service SearchEngineConnectorConfigurable successfully started");
    }

    public ConfigureReturn configure(ConfigureArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException {
        this.logger.debug((Object)"Early start of configure method.");
        PieceOfKnowledge configuration = this.checkConfigureArgs(args);
        this.logger.info((Object)("Configure with configuration " + configuration.getUri() + "."));
        String context = args.getUsageContext();
        try {
            if (context == null) {
                throw new InvalidParameterException("Context is null.");
            }
            if (SearchConnectorConfigurable.getConfigurations().contains(context)) {
                throw new UnsupportedRequestException("Context [" + context + "] is already defined.", "Use resetConfiguration(\"" + context + "\") first.");
            }
            this.createConfiguration(args, context);
        }
        catch (WebLabCheckedException e) {
            this.logger.error((Object)("This is bad man... we cannot serve the request." + e.getMessage()));
            throw new InsufficientResourcesException("This is bad man... we cannot serve the request.", e.getMessage());
        }
        return new ConfigureReturn();
    }

    public ResetConfigurationReturn resetConfiguration(ResetConfigurationArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException {
        this.logger.debug((Object)"Early start of resetConfiguration method.");
        String usageContext = this.checkResetConfigurationArgs(args);
        this.logger.info((Object)("Reset with usage context " + usageContext + "."));
        if (SearchConnector.getSearchConnectors().containsKey(usageContext)) {
            SearchConnector.getSearchConnectors().remove(usageContext);
        } else {
            this.logger.warn((Object)("Configuration [" + usageContext + "] does not exist. Ignoring the deletion request."));
        }
        return new ResetConfigurationReturn();
    }

    @WebResult(name="getConfigurationReturn", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable", partName="return")
    @WebMethod
    public GetConfigurationReturn getConfiguration(@WebParam(partName="args", name="getConfigurationArgs", targetNamespace="http://weblab.ow2.org/core/1.2/services/configurable") GetConfigurationArgs args) throws ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, AccessDeniedException, UnsupportedRequestException, UnexpectedException {
        Map connectors = SearchConnector.getSearchConnectors();
        PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"searchConnector", (String)("config" + System.currentTimeMillis()), PieceOfKnowledge.class);
        JenaPoKHelper hlpr = new JenaPoKHelper(pok);
        hlpr.setAutoCommitMode(false);
        for (Map.Entry entry : connectors.entrySet()) {
            String configURI = pok.getUri() + "#config" + ((String)entry.getKey()).hashCode();
            hlpr.createResStat(configURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "weblab://service/configuration/OpenSearchConnector/config");
            hlpr.createLitStat(configURI, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", (String)entry.getKey());
            if (!(entry.getValue() instanceof OSearchConnector)) continue;
            OSearchConnector connector = (OSearchConnector)entry.getValue();
            hlpr.createLitStat(configURI, "weblab://service/configuration/OpenSearchConnector/urltemplate", connector.getOpenSearchTemplateURL());
            hlpr.createLitStat(configURI, "weblab://service/configuration/OpenSearchConnector/config#query", connector.getQuery());
            hlpr.createLitStat(configURI, "weblab://service/configuration/OpenSearchConnector/config#maxdoc", "" + connector.getMaxDoc());
        }
        hlpr.commit();
        GetConfigurationReturn ret = new GetConfigurationReturn();
        ret.setConfiguration(pok);
        return ret;
    }

    protected PieceOfKnowledge checkConfigureArgs(ConfigureArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("ConfigureArgs is null.");
        }
        PieceOfKnowledge configuration = args.getConfiguration();
        if (configuration == null) {
            throw new InvalidParameterException("Configuration in ConfigureArgs is null.");
        }
        if (args.getUsageContext() == null) {
            throw new InvalidParameterException("UsageContext in ConfigureArgs is null.");
        }
        return configuration;
    }

    protected String checkResetConfigurationArgs(ResetConfigurationArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("ResetConfigurationArgs is null.");
        }
        return args.getUsageContext();
    }

    public static Set<String> getConfigurations() {
        return SearchConnector.getSearchConnectors().keySet();
    }

    protected void createConfiguration(ConfigureArgs args, String context) throws InsufficientResourcesException, InvalidParameterException, WebLabCheckedException {
        PieceOfKnowledge config = args.getConfiguration();
        this.logger.debug((Object)("Config received for context [" + context + "]: " + PoKUtil.getPoKData((PieceOfKnowledge)config)));
        JenaPoKHelper hlpr = new JenaPoKHelper(config);
        Set cfgs = hlpr.getSubjsOnPredRes("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "weblab://service/configuration/OpenSearchConnector/config");
        if (cfgs.size() == 0) {
            throw new InsufficientResourcesException("Configuration invalid.", "There isn't a configuration with rdf:type=weblab://service/configuration/OpenSearchConnector/config");
        }
        if (cfgs.size() > 1) {
            throw new InvalidParameterException("There are multiple configurations.", "What do you want me to do ?");
        }
        String cfgURI = (String)cfgs.iterator().next();
        List cfgURL = hlpr.getLitsOnPredSubj(cfgURI, "weblab://service/configuration/OpenSearchConnector/urltemplate");
        if (cfgURL.size() == 0) {
            throw new InsufficientResourcesException("Configuration invalid.", "There isn't a weblab://service/configuration/OpenSearchConnector/urltemplate value.");
        }
        if (cfgURL.size() > 1) {
            throw new InvalidParameterException("There are multiple URL template defined for the configuration.", "What do you want me to do ?");
        }
        String urlTemplate = (String)cfgURL.iterator().next();
        List cfgQuery = hlpr.getLitsOnPredSubj(cfgURI, "weblab://service/configuration/OpenSearchConnector/config#query");
        if (cfgQuery.size() == 0) {
            throw new InsufficientResourcesException("Configuration invalid.", "There isn't a weblab://service/configuration/OpenSearchConnector/config#query value.");
        }
        if (cfgQuery.size() > 1) {
            throw new InvalidParameterException("There are multiple queries defined for the configuration.", "What do you want me to do ?");
        }
        String query = (String)cfgQuery.iterator().next();
        List cfgMaxDoc = hlpr.getLitsOnPredSubj(cfgURI, "weblab://service/configuration/OpenSearchConnector/config#maxdoc");
        if (cfgMaxDoc.size() == 0) {
            throw new InsufficientResourcesException("Configuration invalid.", "There isn't a weblab://service/configuration/OpenSearchConnector/config#maxdoc value.");
        }
        if (cfgMaxDoc.size() > 1) {
            throw new InvalidParameterException("There are multiple maxDoc defined for the configuration.", "What do you want me to do ?");
        }
        int maxDoc = 10;
        try {
            maxDoc = Integer.parseInt((String)cfgMaxDoc.get(0));
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)"Invalid format for maxDoc property in configuration. Using default 100.", (Throwable)e);
        }
        List cntxts = hlpr.getLitsOnPredSubj(cfgURI, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo");
        if (cntxts.size() == 0 || cntxts.size() > 1) {
            this.logger.warn((Object)("Configuration is not correctly linked to the UsageContext [" + context + "] in RDF/XML."));
        } else {
            String rdfCntxt = (String)cntxts.iterator().next();
            if (context.compareTo(rdfCntxt) != 0) {
                this.logger.warn((Object)("Configuration is linked to an incorrect UsageContext in RDF/XML: [" + rdfCntxt + "] instead of [" + context + "]."));
            }
        }
        SearchConnector.getSearchConnector((String)context, (String)urlTemplate, (String)query, (int)maxDoc);
    }
}

