/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector;

import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.EmptyQueueException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.QueueManager;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.queuemanager.NextResourceArgs;
import org.ow2.weblab.core.services.queuemanager.NextResourceReturn;
import org.ow2.weblab.service.searchconnector.backend.SearchConnector;
import org.ow2.weblab.service.searchconnector.backend.SearchConnectorException;

@WebService(endpointInterface="org.ow2.weblab.core.services.QueueManager")
public class SearchConnectorQueuemanager
implements QueueManager {
    private static final String NO_MORE_RESOURCES = "No more resources for now.";
    private static final String USAGE_CONTEXT_IS_INVALID = "UsageContext is invalid.";
    private static final String NEXT_RESOURCE_ARGS_IS_NULL = "NextResourceArgs is null.";
    private final Log logger = LogFactory.getLog(this.getClass());

    public SearchConnectorQueuemanager() {
        this.logger.info((Object)"Service SearchEngineConnectorQueuemanager successfully started");
    }

    public NextResourceReturn nextResource(NextResourceArgs args) throws ContentNotAvailableException, EmptyQueueException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, ServiceNotConfiguredException, UnsupportedRequestException, AccessDeniedException {
        this.logger.debug((Object)"Early start of nextResource method.");
        String usageContext = this.checkNextResourceArgs(args);
        this.logger.info((Object)("Next resource uses usage context " + usageContext + "."));
        SearchConnector instance = null;
        try {
            instance = SearchConnector.getSearchConnector((String)usageContext);
            if (instance.getQuery() == null) {
                throw new ServiceNotConfiguredException("No query set.");
            }
            if (instance.getMaxDoc() == 0) {
                throw new EmptyQueueException("Max doc limit is 0.");
            }
        }
        catch (WebLabCheckedException e) {
            this.logger.error((Object)(USAGE_CONTEXT_IS_INVALID + e.getMessage()));
            throw new InvalidParameterException(USAGE_CONTEXT_IS_INVALID, e.getMessage());
        }
        try {
            Resource res = instance.loadNextResource();
            if (res == null) {
                this.logger.info((Object)NO_MORE_RESOURCES);
                throw new EmptyQueueException("No more resources for now on context [" + usageContext + "].");
            }
            NextResourceReturn ret = new NextResourceReturn();
            ret.setResource(res);
            return ret;
        }
        catch (WebLabCheckedException e) {
            throw new UnexpectedException("Ahem... something strange happened: " + e.getMessage(), (Throwable)e);
        }
        catch (SearchConnectorException e) {
            throw new EmptyQueueException("No more resources for now on context [" + usageContext + "].");
        }
    }

    protected String checkNextResourceArgs(NextResourceArgs args) throws InvalidParameterException {
        if (args == null) {
            this.logger.error((Object)NEXT_RESOURCE_ARGS_IS_NULL);
            throw new InvalidParameterException(NEXT_RESOURCE_ARGS_IS_NULL);
        }
        if (!args.isSetUsageContext()) {
            this.logger.error((Object)USAGE_CONTEXT_IS_INVALID);
            throw new InvalidParameterException("NextResourceArgs does not have any UsageContext.");
        }
        return args.getUsageContext();
    }
}

