/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector;

import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.service.searchconnector.backend.SearchConnector;

@WebService(endpointInterface="org.ow2.weblab.core.services.Searcher")
public class SearchConnectorSearcher
implements Searcher {
    private final Log logger = LogFactory.getLog(this.getClass());

    public SearchConnectorSearcher() {
        this.logger.info((Object)"Service SearchEngineConnectorSearcher successfully started");
    }

    public SearchReturn search(SearchArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        this.logger.debug((Object)"Early start of search method.");
        Query query = this.checkSearchArgs(args);
        int offset = args.getOffset() == null || args.getOffset() < 0 ? 0 : args.getOffset();
        int limit = args.getOffset() == null || args.getLimit() < 0 ? 10 : args.getLimit();
        this.logger.info((Object)("Start processing query " + query.getUri() + "."));
        String oSearchContext = args.getUsageContext();
        try {
            SearchConnector osc = SearchConnector.getSearchConnector((String)oSearchContext);
            ResultSet res = osc.search(query, offset, limit);
            SearchReturn sr = new SearchReturn();
            sr.setResultSet(res);
            this.logger.info((Object)"Returning results.");
            return sr;
        }
        catch (WebLabCheckedException e) {
            this.logger.error((Object)"An error occured while querying the open search endpoint.");
            throw new UnexpectedException("An error occured while querying the open search endpoint. " + e.getMessage(), (Throwable)e);
        }
    }

    protected Query checkSearchArgs(SearchArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("SearchArgs is null.");
        }
        if (args.getUsageContext() == null || args.getUsageContext().length() == 0) {
            throw new InvalidParameterException("SearchArgs is null or empty.");
        }
        Query query = args.getQuery();
        if (query == null) {
            throw new InvalidParameterException("Resource in SearchArgs is null.");
        }
        if (args.getOffset() == null || args.getOffset() < 0) {
            this.logger.warn((Object)"Offset is null or negative, zero will be used.");
        }
        return query;
    }
}

