/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector.backend;

import java.net.URI;
import java.util.Date;
import java.util.logging.Logger;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.rdf.Value;
import org.ow2.weblab.service.searchconnector.backend.SearchConnector;
import org.purl.dc.elements.DublinCoreAnnotator;
import org.purl.dc.terms.DCTermsAnnotator;

public class SCHit {
    private static final Logger logger = Logger.getLogger(SCHit.class.getName());
    private URI uri;
    private String link;
    private String title;
    private String source;
    private String publisher;
    private Date issueDate;

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public SCHit(URI hitUri, ResultSet rset) {
        this.uri = hitUri;
        DublinCoreAnnotator dca = new DublinCoreAnnotator(hitUri, rset.getPok());
        DCTermsAnnotator dcta = new DCTermsAnnotator(hitUri, rset.getPok());
        WRetrievalAnnotator wrAnnotator = new WRetrievalAnnotator(hitUri, rset.getPok());
        wrAnnotator.startInnerAnnotatorOn(hitUri);
        URI resURI = (URI)wrAnnotator.readLinkedTo().getValues().get(0);
        this.link = resURI.toString();
        dca.startInnerAnnotatorOn(resURI);
        dcta.startInnerAnnotatorOn(resURI);
        Value readTitle = dca.readTitle();
        if (readTitle != null && readTitle.size() == 1) {
            this.title = (String)readTitle.firstTypedValue();
        } else {
            logger.warning("No title on document [" + hitUri + "].");
        }
        Value readSource = dca.readSource();
        if (readSource != null && readSource.size() == 1) {
            this.source = (String)readSource.firstTypedValue();
        } else {
            logger.warning("No source on document [" + hitUri + "].");
        }
        Value readContributor = dca.readContributor();
        if (readContributor != null && readContributor.size() == 1) {
            this.publisher = (String)readContributor.firstTypedValue();
        } else {
            logger.warning("No publisher on document [" + hitUri + "].");
        }
        Value issueDates = dcta.readIssued();
        if (issueDates != null && issueDates.size() == 1) {
            this.issueDate = (Date)issueDates.firstTypedValue();
        } else {
            logger.warning("No issue date on document [" + hitUri + "].");
        }
    }

    public Document getWebLabDoc() {
        Document doc = new Document();
        doc.setUri(this.uri.toString());
        DublinCoreAnnotator annot = new DublinCoreAnnotator((Resource)doc);
        if (this.publisher != null) {
            annot.writePublisher(this.publisher);
        }
        if (this.title != null) {
            annot.writeTitle(this.title);
        }
        if (this.source != null) {
            annot.writeSource(this.source);
        }
        WProcessingAnnotator wpa = new WProcessingAnnotator((Resource)doc);
        wpa.writeProducedBy(SearchConnector.getServiceURI());
        return doc;
    }

    protected URI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }
}

