/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector.backend;

import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.opensearch.OpenSearchModule;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.api.ContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.PoKFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.rdf.Value;
import org.ow2.weblab.service.searchconnector.backend.SCHit;
import org.ow2.weblab.service.searchconnector.backend.SearchConnectorException;
import org.ow2.weblab.service.searchconnector.backend.opensearch.OSearchConnector;

public abstract class SearchConnector {
    private static URI SERVICE_URI;
    public static final String SEARCH_ENDPOINTS_FILE = "searchEndpoints.properties";
    public static final String SERVICE_REF = "searchConnector";
    public static final String SERVICE_URI_STRING = "weblab://searchConnector";
    private static final Log LOGGER;
    private static Map<String, SearchConnector> connectors;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected String serviceRef = "searchConnector";
    private int maxDoc = 50;
    private int currentOffset = -1;
    private int currentLimit = 2;
    private LinkedList<Document> resourceList = new LinkedList();
    private Integer resultCpt = 0;
    private Integer hitCounter = 0;
    private String query;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchConnector getSearchConnector(String urlTemplate) throws WebLabCheckedException {
        if (!connectors.containsKey(urlTemplate)) {
            Map map = connectors;
            synchronized (map) {
                connectors.put(urlTemplate, new OSearchConnector(urlTemplate));
                LOGGER.info((Object)("Creating searchConnector for [" + urlTemplate + "]."));
            }
        }
        return (SearchConnector)connectors.get(urlTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchConnector getSearchConnector(String context, String urlTemplate, String query, int maxDoc) throws WebLabCheckedException {
        if (!connectors.containsKey(context)) {
            Map map = connectors;
            synchronized (map) {
                OSearchConnector connector = new OSearchConnector(urlTemplate);
                connector.setQuery(query);
                connector.setMaxDoc(maxDoc);
                connectors.put(context, connector);
            }
        }
        return (SearchConnector)connectors.get(context);
    }

    public static Map<String, SearchConnector> getSearchConnectors() {
        return connectors;
    }

    public static URI getServiceURI() {
        if (SERVICE_URI == null) {
            try {
                SERVICE_URI = new URI(SERVICE_URI_STRING);
            }
            catch (URISyntaxException e) {
                throw new WebLabUncheckedException("SERVICE_URI_STRING is invalid. WTF !");
            }
        }
        return SERVICE_URI;
    }

    protected abstract void checkQuery(Query var1) throws WebLabCheckedException;

    protected abstract SyndFeed getResultFeed(Query var1, int var2) throws WebLabCheckedException;

    protected abstract String getSearchURL(Query var1, int var2) throws WebLabCheckedException;

    public ResultSet search(Query q, int offset, int limit) throws WebLabCheckedException {
        this.checkQuery(q);
        return this.buildResultSet(q, offset, limit);
    }

    protected ResultSet buildResultSet(Query q, int offset, int limit) throws WebLabCheckedException {
        Module m;
        SyndFeed feed = this.getResultFeed(q, offset);
        Integer n = this.resultCpt;
        Integer n2 = this.resultCpt = Integer.valueOf(this.resultCpt + 1);
        ResultSet resultSet = (ResultSet)ResourceFactory.createResource((String)this.serviceRef, (String)("res" + n), ResultSet.class);
        resultSet.getResource().add(q);
        PieceOfKnowledge pok = PoKFactory.createAndLinkPoK((ResultSet)resultSet);
        resultSet.setPok(pok);
        JenaPoKHelper hlpr = new JenaPoKHelper(pok);
        hlpr.createResStat(resultSet.getUri(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/model#ResultSet");
        hlpr.createResStat(resultSet.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isResultOf", q.getUri());
        hlpr.createLitStat(resultSet.getUri(), "http://purl.org/dc/elements/1.1/source", this.getSearchURL(q, offset));
        if (feed.getDescription() != null) {
            hlpr.createLitStat(resultSet.getUri(), RDFS.label.getURI(), feed.getDescription());
        }
        if (feed.getAuthor() != null) {
            hlpr.createLitStat(resultSet.getUri(), "http://purl.org/dc/elements/1.1/creator", feed.getAuthor());
        }
        if ((m = feed.getModule("http://a9.com/-/spec/opensearch/1.1/")) instanceof OpenSearchModule) {
            OpenSearchModule osm = (OpenSearchModule)m;
            if (osm.getStartIndex() > 0) {
                offset = osm.getStartIndex();
            }
            hlpr.createLitStat(resultSet.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset", "" + offset);
            if (osm.getItemsPerPage() > 0) {
                limit = osm.getItemsPerPage();
            }
            hlpr.createLitStat(resultSet.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit", "" + limit);
            int nbOfResults = -1;
            if (osm.getTotalResults() >= 0) {
                nbOfResults = osm.getTotalResults();
            } else {
                this.logger.warn((Object)("The result feed returns [" + osm.getTotalResults() + "] as total number of results."));
            }
            hlpr.createLitStat(resultSet.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", "" + nbOfResults);
            for (int i = 0; i < feed.getEntries().size(); ++i) {
                SyndEntry entry = (SyndEntry)feed.getEntries().get(i);
                String hitUri = this.buildHitFromSyndEntry(entry, offset + i + 1, hlpr);
                hlpr.createResStat(resultSet.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasHit", hitUri);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Results input : " + ResourceUtil.saveToXMLString((Resource)resultSet)));
        }
        return resultSet;
    }

    protected String buildHitFromSyndEntry(SyndEntry entry, int rank, JenaPoKHelper hlpr) {
        String date;
        GregorianCalendar cal;
        String resourceUri = entry.getUri();
        Integer n = this.hitCounter;
        Integer n2 = this.hitCounter = Integer.valueOf(this.hitCounter + 1);
        String hitUri = "weblab://" + this.serviceRef + "/hit" + n;
        hlpr.createResStat(hitUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit");
        hlpr.createLitStat(hitUri, "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank", "" + rank);
        hlpr.createLitStat(hitUri, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", resourceUri);
        if (entry.getDescription() != null && entry.getDescription().getValue() != null) {
            hlpr.createLitStat(hitUri, "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasDescription", entry.getDescription().getValue());
        }
        if (entry.getLink() != null) {
            hlpr.createLitStat(resourceUri, "http://purl.org/dc/elements/1.1/source", entry.getLink());
        }
        if (entry.getTitle() != null) {
            hlpr.createLitStat(resourceUri, "http://purl.org/dc/elements/1.1/title", entry.getTitle());
        }
        if (entry.getPublishedDate() != null) {
            cal = new GregorianCalendar();
            cal.setTime(entry.getPublishedDate());
            date = DatatypeConverter.printDateTime((Calendar)cal);
            hlpr.createLitStat(resourceUri, DCTerms.issued.toString(), date);
        }
        if (entry.getUpdatedDate() != null) {
            cal = new GregorianCalendar();
            cal.setTime(entry.getUpdatedDate());
            date = DatatypeConverter.printDateTime((Calendar)cal);
            hlpr.createLitStat(resourceUri, DCTerms.modified.toString(), date);
        }
        if (entry.getAuthor() != null && entry.getAuthor().length() > 0) {
            hlpr.createLitStat(resourceUri, DCTerms.contributor.toString(), entry.getAuthor());
        }
        return hitUri;
    }

    private List<SCHit> runQuery() throws SearchConnectorException, WebLabCheckedException {
        try {
            int nbRes;
            LinkedList<SCHit> resultsList = new LinkedList<SCHit>();
            if (this.currentOffset == -1) {
                this.currentOffset = 0;
            } else {
                this.currentOffset += this.currentLimit;
                if (this.currentOffset > this.maxDoc) {
                    throw new SearchConnectorException("End of resources (maxDoc=" + this.maxDoc + " has been reached).");
                }
            }
            this.logger.debug((Object)"Sending query to searcher...");
            StringQuery squery = (StringQuery)ResourceFactory.createResource((String)this.serviceRef, (String)("q" + this.query.hashCode()), StringQuery.class);
            squery.setRequest(this.query);
            ResultSet rset = this.search((Query)squery, this.currentOffset, this.currentLimit);
            this.logger.info((Object)"Results received from searcher.");
            WRetrievalAnnotator wrAnnotator = new WRetrievalAnnotator(new URI(rset.getUri()), rset.getPok());
            Value nbResValues = wrAnnotator.readNumberOfResults();
            if (nbResValues != null && nbResValues.size() == 1 && this.maxDoc > (nbRes = ((Integer)nbResValues.firstTypedValue()).intValue())) {
                this.maxDoc = nbRes;
            }
            if (this.logger.isDebugEnabled()) {
                new WebLabMarshaller().marshalResource((Resource)rset, (OutputStream)System.out);
            }
            if ((Integer)wrAnnotator.readNumberOfResults().getValues().get(0) != 0) {
                for (URI hitUri : wrAnnotator.readHit().getValues()) {
                    wrAnnotator.startInnerAnnotatorOn(hitUri);
                    URI docURI = (URI)wrAnnotator.readLinkedTo().getValues().get(0);
                    if (docURI != null) {
                        SCHit hit = new SCHit(hitUri, rset);
                        resultsList.add(hit);
                    }
                    wrAnnotator.endInnerAnnotator();
                }
            }
            return resultsList;
        }
        catch (URISyntaxException e) {
            throw new WebLabCheckedException("Invalid URI.", (Throwable)e);
        }
    }

    private List<Document> getDocs(List<SCHit> docList) throws WebLabCheckedException {
        LinkedList<Document> resultsList = new LinkedList<Document>();
        this.logger.info((Object)"Getting native content from connector.");
        for (SCHit scHit : docList) {
            Document doc = scHit.getWebLabDoc();
            String link = scHit.getLink();
            this.logger.info((Object)("Getting native content from connector at [" + link + "]."));
            try {
                URL url = new URL(link);
                this.logger.debug((Object)("Getting content from [" + link + "]..."));
                URI ncuri = ContentManager.getInstance().writeNativeContent(url.openStream(), (Resource)doc);
                this.logger.debug((Object)("Native content [" + ncuri + "] saved for document [" + scHit + "] recevied."));
                resultsList.add(doc);
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)("Link to document content is an invalid URL: [" + link + "]. Skipping it."), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.warn((Object)("Cannot open stream to document URL: [" + link + "]. Skipping it."), (Throwable)e);
            }
        }
        return resultsList;
    }

    private int loadResources() throws SearchConnectorException, WebLabCheckedException {
        this.logger.debug((Object)"Loading ressources...");
        long tic = System.currentTimeMillis();
        try {
            List results = this.runQuery();
            List docs = this.getDocs(results);
            this.resourceList.addAll(docs);
        }
        catch (WebLabCheckedException e) {
            throw new WebLabCheckedException("Error while loading resources NativeContentProvider: " + e.getMessage(), (Throwable)e);
        }
        if (this.resourceList.size() > 0) {
            this.logger.debug((Object)(this.resourceList.size() + " items added."));
        } else {
            this.logger.info((Object)"Reach the end of resources iterator list.");
        }
        long toc = System.currentTimeMillis();
        this.logger.info((Object)(this.resourceList.size() + " resources loaded in " + (toc - tic) + "ms."));
        return this.resourceList.size();
    }

    protected boolean hasNext() throws SearchConnectorException, WebLabCheckedException {
        if (this.resourceList.isEmpty()) {
            try {
                this.loadResources();
            }
            catch (WebLabCheckedException e) {
                this.logger.error((Object)e);
                throw new WebLabCheckedException("an error occured while loading next resources: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.resourceList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource loadNextResource() throws SearchConnectorException, WebLabCheckedException {
        Resource res = null;
        LinkedList linkedList = this.resourceList;
        synchronized (linkedList) {
            while (res == null && this.hasNext()) {
                res = (Resource)this.resourceList.getFirst();
                this.resourceList.removeFirst();
            }
        }
        return res;
    }

    public String getQuery() {
        return this.query;
    }

    public int getNumberOfResources() throws WebLabCheckedException {
        return this.resourceList.size();
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public int getCurrentLimit() {
        return this.currentLimit;
    }

    public void setCurrentLimit(int currentLimit) {
        this.currentLimit = currentLimit;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getMaxDoc() {
        return this.maxDoc;
    }

    public void setMaxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    static {
        LOGGER = LogFactory.getLog(SearchConnector.class);
        connectors = new HashMap();
    }
}

