/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector.backend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.util.WebLabQueryParser;

public class SearchQueryParser
extends WebLabQueryParser {
    private Log logger = LogFactory.getLog(this.getClass());

    public String getRequest(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        if (q instanceof StringQuery) {
            return ((StringQuery)q).getRequest();
        }
        if (q instanceof ComposedQuery) {
            return this.getComposedRequest((ComposedQuery)q, hlpr);
        }
        throw new WebLabCheckedException("Cannot get resuqets from query [" + q + "].");
    }

    public String getComposedRequest(ComposedQuery q, ResourceHelper hlpr) throws WebLabCheckedException {
        String operator = q.getOperator().value();
        StringBuffer queryString = new StringBuffer();
        queryString.append('(');
        for (Query subQ : q.getQuery()) {
            if (queryString.length() > 1) {
                queryString.append(' ');
                queryString.append(operator);
                queryString.append(' ');
            }
            if (subQ instanceof StringQuery) {
                queryString.append(this.getRequestWithScope((Query)((StringQuery)subQ), hlpr));
                continue;
            }
            if (subQ instanceof ComposedQuery) {
                queryString.append(this.getComposedRequest((ComposedQuery)subQ, hlpr));
                continue;
            }
            throw new WebLabCheckedException("OSearchQueryParser can only process " + ComposedQuery.class.getSimpleName() + " or " + StringQuery.class.getSimpleName() + ".");
        }
        queryString.append(')');
        return queryString.toString();
    }

    public String getRequestWithScope(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        this.logger.warn((Object)"Query scope are ignored in OSearchQueryParser.");
        return this.getRequest(q, hlpr);
    }

    public String getOrderBy(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        this.logger.warn((Object)"Query order are ignored in OSearchQueryParser.");
        return this.getRequest(q, hlpr);
    }

    public boolean getOrder(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        this.logger.warn((Object)"Query order are ignored in OSearchQueryParser.");
        return false;
    }
}

