/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.searchconnector.backend.opensearch;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.SimilarityQuery;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.service.searchconnector.backend.SearchConnector;
import org.ow2.weblab.service.searchconnector.backend.SearchQueryParser;
import org.ow2.weblab.util.WebLabQueryParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class OSearchConnector
extends SearchConnector {
    private SyndFeedInput input = new SyndFeedInput();
    private WebLabQueryParser parser = new SearchQueryParser();
    private String openSearchTemplateURL;

    public OSearchConnector(String openSearchTemplateURL) throws WebLabCheckedException {
        OSearchConnector.checkSearchTemplateURL((String)openSearchTemplateURL);
        this.openSearchTemplateURL = openSearchTemplateURL;
        this.serviceRef = "openSearch" + openSearchTemplateURL.hashCode();
        this.logger.debug((Object)"OpenSearchConnector successfully created.");
    }

    protected void checkQuery(Query q) throws WebLabCheckedException {
        if (!(q instanceof StringQuery || q instanceof SimilarityQuery || q instanceof ComposedQuery)) {
            throw new WebLabCheckedException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + " or " + ComposedQuery.class.getSimpleName() + ". Input has invalid type:" + q.getClass() == null ? " no xsi:type !" : q.getClass().getSimpleName());
        }
        try {
            if (q instanceof StringQuery) {
                this.logger.debug((Object)("String query request : " + ((StringQuery)q).getRequest()));
            } else if (q instanceof ComposedQuery) {
                this.logger.debug((Object)("Composed query request containing " + ((ComposedQuery)q).getQuery().size() + " queries combined with " + ((ComposedQuery)q).getOperator()));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Query input : " + ResourceUtil.saveToXMLString((Resource)q)));
            }
        }
        catch (WebLabCheckedException e) {
            this.logger.debug((Object)"Error when logging query input", (Throwable)e);
        }
    }

    protected SyndFeed getResultFeed(Query q, int startPage) throws WebLabCheckedException {
        try {
            URL restURL = new URL(this.getSearchURL(q, startPage));
            this.logger.debug((Object)("OpenSearchConnector querying [" + restURL + "]..."));
            SyndFeed feed = this.input.build((Reader)new XmlReader(restURL));
            if (feed == null) {
                throw new WebLabCheckedException("Ahem... OpenSearch feed isn't valid.");
            }
            this.logger.debug((Object)"OpenSearchConnector query success !");
            return feed;
        }
        catch (MalformedURLException e) {
            throw new WebLabCheckedException("Aham... OpenSearch URL wasn't valid. That should have been validated before.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new WebLabCheckedException("Well... Cannot build feed on the xml stream from [" + this.openSearchTemplateURL + "].", (Throwable)e);
        }
        catch (FeedException e) {
            throw new WebLabCheckedException("Ooh... Cannot parse the results from [" + this.openSearchTemplateURL + "].", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Sh\u00a3t... Cannot read the stream from [" + this.openSearchTemplateURL + "].", (Throwable)e);
        }
    }

    protected String getSearchURL(Query q, int startPage) throws WebLabCheckedException {
        JenaResourceHelper hlpr = new JenaResourceHelper((Resource)q);
        String searchTerms = this.parser.getRequest(q, (ResourceHelper)hlpr);
        this.logger.info((Object)("Searching for [" + searchTerms + "] on " + this.getOpenSearchTemplateURL()));
        return this.openSearchTemplateURL.replace("{searchTerms}", searchTerms).replace("{startPage}", "" + startPage);
    }

    private static void checkSearchTemplateURL(String openSearchTemplateURL) throws WebLabCheckedException {
        if (!openSearchTemplateURL.contains("searchTerms")) {
            throw new WebLabCheckedException("Open search endpoint does not contain searchTerms in URL template. Cannot instanciate the service.");
        }
        try {
            new URL(openSearchTemplateURL.replace("{searchTerms}", "test").replace("{startPage}", "0"));
        }
        catch (MalformedURLException e) {
            throw new WebLabCheckedException("Open search endpoint has invalid URL template : [" + openSearchTemplateURL + "] . Cannot instanciate the service.");
        }
    }

    public String getOpenSearchTemplateURL() {
        return this.openSearchTemplateURL;
    }
}

