/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.splitter.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.helper.RDFHelperFactory;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.springframework.core.io.ClassPathResource;

@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class WLRSSSplitter
implements Analyser {
    protected static Properties PROPS;
    protected static Log LOGGER;
    protected static SimpleDateFormat SDF;
    public static final String SERVICE_REF = "rss-splitter";

    @PostConstruct
    public void init() throws Exception {
        if (PROPS == null) {
            PROPS = new Properties();
            ClassPathResource classPathResource = new ClassPathResource("rss-splitter.properties");
            PROPS.load(classPathResource.getInputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessReturn process(ProcessArgs args) throws ContentNotAvailableException {
        String source = this.checkResource(args.getResource());
        ComposedResource resourceCollection = (ComposedResource)ResourceFactory.createResource((String)SERVICE_REF, (String)("rc_" + System.currentTimeMillis()), ComposedResource.class);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            URI uri = this.getNativeContent(args.getResource());
            SyndFeedInput feedInput = new SyndFeedInput();
            org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(uri.toURL().openStream());
            SyndFeed syndFeed = feedInput.build(doc);
            for (Object feed : syndFeed.getEntries()) {
                if (!(feed instanceof SyndEntry)) continue;
                Resource res = this.buildResourceFromSyndEntry((SyndEntry)feed, source);
                resourceCollection.getResource().add(res);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Unable to parse content, maybe not an RSS Feed : " + e), (Throwable)e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.info((Object)("Unable to close stream : " + e.getMessage()), (Throwable)e);
                }
            }
        }
        ProcessReturn processReturn = new ProcessReturn();
        processReturn.setResource((Resource)resourceCollection);
        if (resourceCollection.getResource().size() == 0) {
            resourceCollection.getResource().add(args.getResource());
        }
        return processReturn;
    }

    public String checkResource(Resource resource) throws ContentNotAvailableException {
        String source = null;
        URI uri = this.getNativeContent(resource);
        if (uri == null) {
            throw new ContentNotAvailableException("Source can not be null.", "Source can not be null.");
        }
        ResourceHelper resourceHelper = RDFHelperFactory.getResourceHelper((Resource)resource);
        List sources = resourceHelper.getLitsOnPredSubj(resource.getUri(), "http://purl.org/dc/elements/1.1/source");
        if (sources.size() > 0) {
            if (sources.size() > 1) {
                LOGGER.warn((Object)("Multiple sources annotation, taking the first one: " + (String)sources.get(0)));
            }
        } else {
            throw new ContentNotAvailableException("Source can not be null.", "Source can not be null.");
        }
        source = (String)sources.get(0);
        return source;
    }

    protected Resource buildResourceFromSyndEntry(SyndEntry syndEntry, String source) {
        LOGGER.info((Object)"Creating RSS Feed Entry resource.");
        Document document = (Document)ResourceFactory.createResource((String)SERVICE_REF, (String)("doc_" + System.currentTimeMillis()), Document.class);
        PoKHelper poKHelper = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)AnnotationFactory.createAndLinkAnnotation((Resource)document));
        poKHelper.setAutoCommitMode(false);
        if (syndEntry.getTitle() != null && syndEntry.getTitle().length() > 0) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("title"), syndEntry.getTitle());
            LOGGER.trace((Object)("Feed title: " + syndEntry.getTitle()));
        }
        if (syndEntry.getAuthors() != null) {
            for (Object author : syndEntry.getAuthors()) {
                if (!(author instanceof String)) continue;
                String strAuthor = (String)author;
                poKHelper.createLitStat(document.getUri(), PROPS.getProperty("author"), strAuthor);
                LOGGER.trace((Object)("Feed author: " + strAuthor));
            }
        } else if (syndEntry.getAuthor() != null && syndEntry.getAuthor().length() > 0) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("author"), syndEntry.getAuthor());
            LOGGER.trace((Object)("Feed author: " + syndEntry.getAuthor()));
        }
        if (syndEntry.getUri() != null && syndEntry.getUri().length() > 0) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("source"), source);
            LOGGER.trace((Object)("Feed source: " + source));
        }
        if (syndEntry.getDescription() != null && syndEntry.getDescription().getType() != null && syndEntry.getDescription().getType().length() > 0) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("format"), "application/rss+xml");
            LOGGER.trace((Object)("Feed format: " + syndEntry.getDescription().getType()));
        }
        if (syndEntry.getPublishedDate() != null) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("date"), SDF.format(syndEntry.getPublishedDate()));
            LOGGER.trace((Object)("Feed date: " + syndEntry.getPublishedDate()));
        } else if (syndEntry.getUpdatedDate() != null) {
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("date"), SDF.format(syndEntry.getUpdatedDate()));
            LOGGER.trace((Object)("Feed date: " + syndEntry.getUpdatedDate()));
        } else {
            Date curDate = new Date();
            LOGGER.warn((Object)("No date in the feed, using current: " + curDate));
            poKHelper.createLitStat(document.getUri(), PROPS.getProperty("date"), SDF.format(curDate));
            LOGGER.trace((Object)("Feed date: " + curDate));
        }
        poKHelper.commit();
        return document;
    }

    private URI getNativeContent(Resource resource) {
        WProcessingAnnotator wpa = new WProcessingAnnotator(resource);
        return (URI)wpa.readNativeContent().firstTypedValue();
    }

    static {
        LOGGER = LogFactory.getLog(WLRSSSplitter.class);
        SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
    }
}

