/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.service;

import java.io.File;

import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.DataOperator;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.dataoperator.DeleteArgs;
import org.ow2.weblab.core.services.dataoperator.DeleteReturn;
import org.ow2.weblab.core.services.dataoperator.DropArgs;
import org.ow2.weblab.core.services.dataoperator.DropReturn;
import org.ow2.weblab.core.services.dataoperator.ReportArgs;
import org.ow2.weblab.core.services.dataoperator.ReportReturn;

@WebService(endpointInterface = "org.ow2.weblab.core.services.DataOperator")
public class FullDataManagment extends SimpleRepo implements DataOperator{

	private Log logger = LogFactory.getLog(FullDataManagment.class);
	
	public FullDataManagment(String path) {
		super(path);
	}
	
	@Override
	public DeleteReturn delete(DeleteArgs args)
			throws ServiceNotConfiguredException,
			InsufficientResourcesException, UnexpectedException,
			InvalidParameterException, AccessDeniedException,
			ContentNotAvailableException, UnsupportedRequestException {
		String uri = args.getUri();
		final File file = super.uriToFile(uri);
		if (!file.delete()){
			logger.error("Could not delete file "+file+" from "+uri);
			throw new UnexpectedException("Could not delete "+uri);
		}
		return new DeleteReturn();
	}


	@Override
	public DropReturn drop(DropArgs args) throws ServiceNotConfiguredException,
			InsufficientResourcesException, UnexpectedException,
			InvalidParameterException, AccessDeniedException,
			ContentNotAvailableException, UnsupportedRequestException {
		throw new UnsupportedRequestException("Drop not implemented, go delete "+repoBase.getAbsolutePath()+" by hand.");
	}


	@Override
	public ReportReturn report(ReportArgs args)
			throws ServiceNotConfiguredException,
			InsufficientResourcesException, UnexpectedException,
			InvalidParameterException, AccessDeniedException,
			ContentNotAvailableException, UnsupportedRequestException {
		throw new UnsupportedRequestException("Report operation not implemented.");
	}

}
