/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service;

import java.io.File;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.DataOperator;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.dataoperator.DeleteArgs;
import org.ow2.weblab.core.services.dataoperator.DeleteReturn;
import org.ow2.weblab.core.services.dataoperator.DropArgs;
import org.ow2.weblab.core.services.dataoperator.DropReturn;
import org.ow2.weblab.core.services.dataoperator.ReportArgs;
import org.ow2.weblab.core.services.dataoperator.ReportReturn;
import org.ow2.weblab.service.SimpleRepo;

@WebService(endpointInterface="org.ow2.weblab.core.services.DataOperator")
public class FullDataManagment
extends SimpleRepo
implements DataOperator {
    private Log logger = LogFactory.getLog(FullDataManagment.class);

    public FullDataManagment(String path) {
        super(path);
    }

    public DeleteReturn delete(DeleteArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        String uri = args.getUri();
        File file = super.uriToFile(uri);
        if (!file.delete()) {
            this.logger.error((Object)("Could not delete file " + file + " from " + uri));
            throw new UnexpectedException("Could not delete " + uri);
        }
        return new DeleteReturn();
    }

    public DropReturn drop(DropArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        throw new UnsupportedRequestException("Drop not implemented, go delete " + this.repoBase.getAbsolutePath() + " by hand.");
    }

    public ReportReturn report(ReportArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        throw new UnsupportedRequestException("Report operation not implemented.");
    }
}

