/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service;

import java.io.File;
import javax.jws.WebService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceReturn;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceReturn;

@WebService(endpointInterface="org.ow2.weblab.core.services.ResourceContainer")
public class SimpleRepo
implements ResourceContainer {
    protected final File repoBase;
    protected final WebLabMarshaller reader;
    protected final WebLabMarshaller writer;
    private final Log logger;

    public SimpleRepo(String path) {
        if (path == null) {
            throw new WebLabUncheckedException("Path was null.");
        }
        this.logger = LogFactory.getLog(this.getClass());
        this.repoBase = new File(path);
        if (!this.repoBase.exists() && !this.repoBase.mkdirs()) {
            throw new WebLabUncheckedException("Unable to create repository base directory '" + this.repoBase + "' from parameter '" + path + "'.");
        }
        if (!this.repoBase.isDirectory()) {
            throw new WebLabUncheckedException("A file exists where the base directory should be ('" + this.repoBase + "' from parameter '" + path + "').");
        }
        if (!this.repoBase.canRead() || !this.repoBase.canWrite()) {
            throw new WebLabUncheckedException("The base directory '" + this.repoBase + "' (from parameter '" + path + "') is not readable or not writable.");
        }
        this.reader = new WebLabMarshaller();
        this.writer = new WebLabMarshaller();
        this.logger.info((Object)("SimpleRepository successfully started. Using '" + this.repoBase.getAbsolutePath() + "' as base directory."));
    }

    public LoadResourceReturn loadResource(LoadResourceArgs args) throws InvalidParameterException, UnexpectedException {
        String uri = this.checkGetResourceArgs(args);
        this.logger.debug((Object)("Try to retrieve resource from URI '" + uri + "'."));
        File file = this.uriToFile(uri);
        this.logger.debug((Object)("Try to extract resource from file '" + file.getAbsolutePath() + "'."));
        Resource res = this.readFile(file, uri);
        this.logger.debug((Object)("Return the resource having '" + uri + "' has URI and read from file '" + file.getAbsolutePath() + "'."));
        LoadResourceReturn grr = new LoadResourceReturn();
        grr.setResource(res);
        return grr;
    }

    public SaveResourceReturn saveResource(SaveResourceArgs args) throws InvalidParameterException, UnexpectedException {
        Resource res = this.checkSaveResourceArgs(args);
        this.logger.debug((Object)("Try to save resource with URI '" + res.getUri() + "'."));
        File file = this.uriToFile(res.getUri());
        this.logger.debug((Object)("File '" + file.getAbsolutePath() + "' will be used."));
        this.writeFile(file, res);
        this.logger.debug((Object)("Return the URI '" + res.getUri() + "' of the resource that has been successfully stored in file '" + file.getAbsolutePath() + "'."));
        SaveResourceReturn srr = new SaveResourceReturn();
        srr.setResourceId(res.getUri());
        return srr;
    }

    private synchronized void writeFile(File file, Resource res) throws UnexpectedException {
        try {
            this.writer.marshalResource(res, file);
        }
        catch (WebLabCheckedException wlce) {
            throw new UnexpectedException("Error when marshalling the resource with URI '" + res.getUri() + "' in file '" + file.getAbsolutePath() + "'.", (Throwable)wlce);
        }
    }

    private Resource checkSaveResourceArgs(SaveResourceArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("SaveResourceArgs is null.");
        }
        if (args.getResource() == null) {
            throw new InvalidParameterException("Resource in SaveResourceArgs is null.");
        }
        String uri = args.getResource().getUri();
        if (uri == null) {
            InvalidParameterException wle = new InvalidParameterException("URI of the Resource in SaveResourceArgs is null.");
            throw wle;
        }
        return args.getResource();
    }

    private synchronized Resource readFile(File file, String uri) throws UnexpectedException {
        if (!file.exists()) {
            throw new UnexpectedException("No resource with '" + uri + "' as URI found. File " + file.getAbsolutePath() + " not found.");
        }
        try {
            return this.reader.unmarshal(file, Resource.class);
        }
        catch (WebLabCheckedException wlce) {
            throw new UnexpectedException("Error when unmarshalling the file" + file.getAbsolutePath() + " from URI '" + uri + "'.", (Throwable)wlce);
        }
    }

    protected File uriToFile(String uri) {
        String sha = DigestUtils.sha256Hex((String)uri);
        File folder = new File(this.repoBase, sha.substring(0, 1));
        if (!folder.exists() && !folder.mkdirs()) {
            this.logger.warn((Object)("An error occurs while creating folder " + folder.getAbsolutePath() + " used to store resource with " + uri + " as URI."));
        }
        return new File(folder, sha + ".xml");
    }

    private String checkGetResourceArgs(LoadResourceArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("LoadResourceArgs is null");
        }
        String uri = args.getResourceId();
        if (uri == null) {
            throw new InvalidParameterException("uri inLoadResourceArgs is null");
        }
        return uri;
    }
}

