/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gazetteer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.service.gazetteer.AnnotatorFromGazMixed;
import org.ow2.weblab.service.gazetteer.SuffixFilefilter;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class GazetteerImpl
implements Analyser {
    @Resource
    protected WebServiceContext webServiceContext;
    protected static Map<String, Set<String>> gaz;
    protected Analyser annotator;
    protected Log logger;
    protected static boolean LOADED;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(this.getClass());
        this.annotator = new AnnotatorFromGazMixed(this.logger);
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        if (!LOADED) {
            ServletContext servletContext = (ServletContext)this.webServiceContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            this.loadGaz(new File(servletContext.getRealPath("WEB-INF/classes/gaz/")), ".lst");
        }
        return this.annotator.process(args);
    }

    protected synchronized void loadGaz(File gazFolder, String suffix) {
        SuffixFilefilter suffixFilefilter = new SuffixFilefilter(suffix);
        gaz = Collections.synchronizedMap(new HashMap());
        for (File file : gazFolder.listFiles((FilenameFilter)suffixFilefilter)) {
            try {
                this.loadFile(file);
            }
            catch (IOException e) {
                this.logger.error((Object)("Unable to load Gazetteer file : " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        this.logger.debug((Object)("Gazetteer loaded: " + gaz));
        LOADED = true;
    }

    protected void loadFile(File gazFile) throws IOException {
        FileInputStream fis;
        String className = gazFile.getName().split("\\.")[0];
        HashSet<String> wordSet = new HashSet<String>();
        if (gaz.get(className) != null) {
            throw new IOException("Gazetteer class '" + className + "' is already set.");
        }
        try {
            fis = new FileInputStream(gazFile);
        }
        catch (FileNotFoundException fnfe) {
            this.logger.error((Object)("File '" + gazFile.getAbsolutePath() + "' not found."), (Throwable)fnfe);
            throw fnfe;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            String word = br.readLine();
            while (word != null) {
                String toBeAdded = word.trim();
                this.logger.trace((Object)("Adding '" + toBeAdded + "' to class '" + className + "'."));
                if (!word.isEmpty()) {
                    wordSet.add(toBeAdded);
                }
                word = br.readLine();
            }
            gaz.put(className, wordSet);
            this.logger.info((Object)("Loading finish for class '" + className + "', " + wordSet.size() + " words loaded."));
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Unable to read content of File '" + gazFile.getAbsolutePath() + "'."), (Throwable)ioe);
            throw ioe;
        }
    }

    static {
        LOADED = false;
    }
}

