/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gazetteer.api;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.SegmentFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;

public abstract class TextAnnotator
implements Analyser {
    protected Log logger;

    public TextAnnotator(Log logger) {
        this.logger = logger;
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        List texts = this.checkParameters(args);
        this.logger.debug((Object)("Start processing resource " + args.getResource() + ". It contains " + texts.size() + " texts."));
        for (Text text : texts) {
            this.process(text);
        }
        ProcessReturn ret = new ProcessReturn();
        ret.setResource(args.getResource());
        return ret;
    }

    public void annote(Text text, int offset, String word, String className, String label, boolean createAnnotation) {
        this.logger.debug((Object)("Creating segment : " + offset + " - " + word));
        LinearSegment linearSegment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)offset, (int)(offset + word.length()));
        Annotation annotation = null;
        if (!createAnnotation && text.getAnnotation().size() > 0) {
            annotation = (Annotation)text.getAnnotation().get(0);
        }
        if (annotation == null) {
            annotation = AnnotationFactory.createAndLinkAnnotation((Resource)text);
        }
        String instanceUri = "http://weblab.ow2.org/core/1.2/ontology/processing#temp-" + new Date().getTime();
        JenaPoKHelper h = new JenaPoKHelper((PieceOfKnowledge)annotation);
        h.setAutoCommitMode(false);
        h.createResStat(linearSegment.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo", instanceUri);
        h.createResStat(instanceUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/processing#demo-" + className);
        h.createLitStat(instanceUri, "http://www.w3.org/2000/01/rdf-schema#label", label);
        h.createLitStat(instanceUri, "http://weblab.ow2.org/core/1.2/ontology/processing#isCandidate", "true");
        h.commit();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Word annotated : " + word + " class " + className + " -> " + offset));
            this.logger.debug((Object)("In text : '" + text.getContent().substring(offset, offset + word.length()) + "'"));
        }
    }

    public abstract void process(Text var1) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException;

    protected List<Text> checkParameters(ProcessArgs args) throws InvalidParameterException {
        List<Text> texts;
        if (args == null) {
            throw new InvalidParameterException("ProcessArgs was null.", "ProcessArgs was null.");
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new InvalidParameterException("Resource in ProcessArg was null.", "Resource in ProcessArg was null.");
        }
        if (!(res instanceof MediaUnit)) {
            throw new InvalidParameterException("This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".", "This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".");
        }
        if (res instanceof Text) {
            texts = new LinkedList<Text>();
            texts.add((Text)res);
        } else {
            texts = ResourceUtil.getSelectedSubResources((Resource)args.getResource(), Text.class);
        }
        ListIterator textIt = texts.listIterator();
        while (textIt.hasNext()) {
            Text text = (Text)textIt.next();
            if (text.getContent() != null && !text.getContent().replaceAll("\\s+", "").isEmpty()) continue;
            textIt.remove();
        }
        return texts;
    }
}

