/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gazetteer;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.service.gazetteer.ASCIINormaliser;
import org.ow2.weblab.service.gazetteer.GazetteerImpl;
import org.ow2.weblab.service.gazetteer.api.TextAnnotator;

public class AnnotatorFromGazFullRegexp
extends TextAnnotator {
    public AnnotatorFromGazFullRegexp(Log logger) {
        super(logger);
    }

    public void process(Text text) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        String content = ASCIINormaliser.normalise((String)text.getContent());
        for (Map.Entry gazEntry : GazetteerImpl.gaz.entrySet()) {
            this.logger.debug((Object)("Entering gaz class : " + (String)gazEntry.getKey() + " - " + ((Set)gazEntry.getValue()).size()));
            for (String word : (Set)gazEntry.getValue()) {
                String normalisedWord = ASCIINormaliser.normalise((String)word);
                this.logger.trace((Object)("Test gaz word : '" + normalisedWord + "' - " + normalisedWord.length()));
                if (normalisedWord.length() <= 0) continue;
                Pattern p = Pattern.compile("(?:^|\\W)(" + normalisedWord + ")(?:$|\\W)");
                Matcher m = p.matcher(content);
                while (m.find()) {
                    this.annote(text, m.start(1), normalisedWord, (String)gazEntry.getKey(), word, false);
                }
            }
        }
    }
}

