/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gazetteer;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.service.gazetteer.GazetteerImpl;
import org.ow2.weblab.service.gazetteer.api.TextAnnotator;

public class AnnotatorFromGazMixed
extends TextAnnotator {
    public AnnotatorFromGazMixed(Log logger) {
        super(logger);
    }

    public void process(Text text) throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        String content = text.getContent().toLowerCase();
        for (Map.Entry gazEntry : GazetteerImpl.gaz.entrySet()) {
            this.logger.debug((Object)("Entering gaz class : " + (String)gazEntry.getKey() + " - " + ((Set)gazEntry.getValue()).size()));
            for (String word : (Set)gazEntry.getValue()) {
                int index = 0;
                while ((index = content.indexOf(word.toLowerCase(), index)) >= 0) {
                    boolean before = true;
                    boolean after = true;
                    if (index > 0) {
                        before = ("" + content.charAt(index - 1)).matches("\\W");
                    }
                    if (index + word.length() < content.length()) {
                        after = ("" + content.charAt(index + word.length())).matches("\\W");
                    }
                    if (before && after) {
                        this.annote(text, index, word, (String)gazEntry.getKey(), word, false);
                    }
                    index += word.length();
                }
            }
        }
    }
}

