/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.duplicates;

import java.io.File;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.update.processor.TextProfileSignature;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.services.indexer.impl.SolrIndexer;
import org.ow2.weblab.services.searcher.impl.SolrSearcher;
import org.ow2.weblab.services.solr.SolrComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class DuplicatesDetectorService
implements Analyser {
    private static final Log logger = LogFactory.getLog(DuplicatesDetectorService.class);
    @javax.annotation.Resource
    protected WebServiceContext wsContext;
    private SolrComponent comp;

    public ProcessReturn process(ProcessArgs args) throws UnexpectedException, InvalidParameterException {
        MediaUnit unit = DuplicatesDetectorService.checkArgs((ProcessArgs)args);
        logger.info((Object)("Process method of DuplicatesDetectorService called for Document: " + unit.getUri()));
        boolean docIsAlreadyPresent = false;
        this.comp = SolrComponent.getInstance();
        try {
            this.comp.open(this.getWebAppPath());
            String sigString = DuplicatesDetectorService.getFuzzyHashing((MediaUnit)unit);
            logger.info((Object)("Signature of doc to process: " + sigString));
            QueryResponse qr = this.comp.search("signature:" + sigString, 0, 1);
            if (qr.getResults() != null && qr.getResults().size() > 0) {
                for (SolrDocument hit : qr.getResults()) {
                    docIsAlreadyPresent = true;
                    logger.info((Object)("Duplicate document found: " + String.valueOf(hit.getFieldValue("id"))));
                }
            } else {
                logger.info((Object)"No near duplicates found, add document to index.");
                this.comp.addDocument((Resource)unit);
                this.comp.flushIndexBuffer();
            }
            if (docIsAlreadyPresent) {
                logger.info((Object)("Document (" + unit.getUri() + ") is a duplicate."));
                Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)unit);
                JenaPoKHelper pokHlp = new JenaPoKHelper((PieceOfKnowledge)annot);
                pokHlp.createLitStat(unit.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#canBeIgnored", "true");
            } else {
                logger.info((Object)("Document (" + unit.getUri() + ") is a new document."));
            }
        }
        catch (WebLabCheckedException wle) {
            wle.printStackTrace();
            throw new UnexpectedException("Error when calling solr index.", wle.getMessage(), (Throwable)wle);
        }
        ProcessReturn pr = new ProcessReturn();
        pr.setResource((Resource)unit);
        return pr;
    }

    private static String getFuzzyHashing(MediaUnit unit) {
        TextProfileSignature tps = new TextProfileSignature();
        tps.init(SolrParams.toSolrParams((NamedList)new NamedList()));
        tps.add("text");
        tps.add(SolrComponent.extractTextFromResource((Resource)unit));
        byte[] signature = tps.getSignature();
        char[] arr = new char[signature.length << 1];
        for (int i = 0; i < signature.length; ++i) {
            byte b = signature[i];
            int idx = i << 1;
            arr[idx] = StrUtils.HEX_DIGITS[b >> 4 & 0xF];
            arr[idx + 1] = StrUtils.HEX_DIGITS[b & 0xF];
        }
        return new String(arr);
    }

    private static MediaUnit checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"IndexArgs was null.");
            throw new InvalidParameterException("IndexArgs was null.");
        }
        if (args.getResource() == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Args must contain a non-null Resource to index");
            throw new InvalidParameterException("Args must contain a non-null Resource to index");
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Resource to index as not a MediaUnit.");
            throw new InvalidParameterException("Resource to index as not a MediaUnit.");
        }
        return (MediaUnit)args.getResource();
    }

    private String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            LogFactory.getLog(SolrSearcher.class).warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

