/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.index;

import java.util.List;

public class Field {


	/**
	 * Name of the field in the index
	 */
	protected String name;


	/**
	 * Field type : should be text, number, date
	 */
	protected String type;


	/**
	 * Indicate if the field contain MediaUnit text parts
	 */
	protected boolean indexTextMediaUnit;


	/**
	 * List of entityTypes indexed in this field
	 */
	protected List<String> properties;


	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}


	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(final String name) {
		this.name = name;
	}


	/**
	 * @return the type
	 */
	public String getType() {
		return this.type;
	}


	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(final String type) {
		this.type = type;
	}


	/**
	 * @return the indexTextMediaUnit
	 */
	public boolean isIndexTextMediaUnit() {
		return this.indexTextMediaUnit;
	}


	/**
	 * @param indexTextMediaUnit
	 *            the indexTextMediaUnit to set
	 */
	public void setIndexTextMediaUnit(final boolean indexTextMediaUnit) {
		this.indexTextMediaUnit = indexTextMediaUnit;
	}


	/**
	 * @return the entityTypes
	 */
	public List<String> getProperties() {
		return this.properties;
	}


	/**
	 * @param properties
	 *            The properties
	 */
	public void setProperties(final List<String> properties) {
		this.properties = properties;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + (this.indexTextMediaUnit ? 1231 : 1237);
		result = (prime * result) + ((this.name == null) ? 0 : this.name.hashCode());
		result = (prime * result) + ((this.properties == null) ? 0 : this.properties.hashCode());
		result = (prime * result) + ((this.type == null) ? 0 : this.type.hashCode());
		return result;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		final Field other = (Field) obj;
		if (this.indexTextMediaUnit != other.indexTextMediaUnit) {
			return false;
		}
		if (this.name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!this.name.equals(other.name)) {
			return false;
		}
		if (this.properties == null) {
			if (other.properties != null) {
				return false;
			}
		} else if (!this.properties.equals(other.properties)) {
			return false;
		}
		if (this.type == null) {
			if (other.type != null) {
				return false;
			}
		} else if (!this.type.equals(other.type)) {
			return false;
		}
		return true;
	}


	@Override
	public String toString() {
		return "Field [indexTextMediaUnit=" + this.indexTextMediaUnit + ", name=" + this.name + ", properties=" + this.properties + ", type=" + this.type + "]";
	}

}
