/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.search;

import java.util.List;
import java.util.Map;

public class SearcherConfig {


	public static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";


	/**
	 * Default id pok
	 */
	public static final String DEFAULT_IDPOK = "pok";


	/**
	 * Default id hit
	 */
	public static final String DEFAULT_IDHIT = "hit";


	/**
	 * Default id facet
	 */
	public static final String DEFAULT_IDFACET = "facet";


	/**
	 * Default id facet value
	 */
	public static final String DEFAULT_IDFACETVALUE = "facetValue";


	/**
	 * Summary key
	 */
	public static final String SUMMARY_KEY = "summary";


	/**
	 * Exalead produced from key
	 */
	public static final String PRODUCED_FROM_KEY = "isProducedFrom";


	/**
	 * Results key
	 */
	public static final String RESULTS_FROM_KEY = "isResultOf";


	/**
	 * Results number key
	 */
	public static final String NB_RESULTS_KEY = "hasNumberOfResults";


	/**
	 * Offset key
	 */
	public static final String OFFSET_KEY = "offset";


	/**
	 * Rank key
	 */
	public static final String HAS_RANK_KEY = "hasRank";


	/**
	 * Score key
	 */
	public static final String SCORE_KEY = "hasScore";


	/**
	 * Description key
	 */
	public static final String DESCRIPTION_KEY = "hasDescription";


	/**
	 * Linked to key
	 */
	public static final String LINKED_TO_KEY = "isLinkedTo";


	/**
	 * in result set key
	 */
	public static final String IN_RESULT_SET_KEY = "inResultSet";


	/**
	 * default name for indexer configuration bean
	 */
	public static final String DEFAULT_BEAN_NAME = "SearcherConfig";


	/**
	 * Field/entityTypes mapping for the entityTypes that will be retrieved in the document
	 */
	protected Map<String, String> properties;


	/**
	 * Map of String to be used as namespace prefix in the RDF/XML
	 */
	protected Map<String, String> nsPrefixProperties;


	/**
	 * Hit class
	 */
	protected String hitClass;


	/**
	 * Facet class
	 */
	protected String facetClass;


	/**
	 * Facet value class
	 */
	protected String facetValueClass;


	/**
	 * Facet count class
	 */
	protected String facetCountClass;


	/**
	 * Facet filter query class
	 */
	protected String facetFilterQueryClass;


	/**
	 * Facet filter query class
	 */
	protected String isLinkedToQueryClass;


	/**
	 * Facet filter query class
	 */
	protected String isLinkedToFacetClass;


	/**
	 * Facet fields list
	 */
	protected List<String> facetFields;


	/**
	 * Count min value
	 */
	protected int facetMinCount;


	/**
	 * Max number of facet elements
	 */
	protected int facetLimitNumber;


	public SearcherConfig() {
		super();
	}


	/**
	 * @return the entityTypes
	 */
	public Map<String, String> getProperties() {
		return this.properties;
	}


	/**
	 * @param properties
	 *            The properties
	 */
	public void setProperties(final Map<String, String> properties) {
		this.properties = properties;
	}


	/**
	 * @return the nsPrefixProperties
	 */
	public Map<String, String> getNsPrefixProperties() {
		return this.nsPrefixProperties;
	}


	/**
	 * @param nsPrefixProperties
	 *            the nsPrefixProperties to set
	 */
	public void setNsPrefixProperties(final Map<String, String> nsPrefixProperties) {
		this.nsPrefixProperties = nsPrefixProperties;
	}


	/**
	 * @return the hitClass
	 */
	public String getHitClass() {
		return this.hitClass;
	}


	/**
	 * @param hitClass
	 *            the hitClass to set
	 */
	public void setHitClass(final String hitClass) {
		this.hitClass = hitClass;
	}


	/**
	 * @return the facetClass
	 */
	public String getFacetClass() {
		return this.facetClass;
	}


	/**
	 * @param facetClass
	 *            the facetClass to set
	 */
	public void setFacetClass(final String facetClass) {
		this.facetClass = facetClass;
	}


	/**
	 * @return the facetValueClass
	 */
	public String getFacetValueClass() {
		return this.facetValueClass;
	}


	/**
	 * @param facetValueClass
	 *            the facetValueClass to set
	 */
	public void setFacetValueClass(final String facetValueClass) {
		this.facetValueClass = facetValueClass;
	}


	/**
	 * @return the facetCountClass
	 */
	public String getFacetCountClass() {
		return this.facetCountClass;
	}


	/**
	 * @param facetCountClass
	 *            the facetCountClass to set
	 */
	public void setFacetCountClass(final String facetCountClass) {
		this.facetCountClass = facetCountClass;
	}


	/**
	 * @return the facetFilterQueryClass
	 */
	public String getFacetFilterQueryClass() {
		return this.facetFilterQueryClass;
	}


	/**
	 * @param facetFilterQueryClass
	 *            the facetFilterQueryClass to set
	 */
	public void setFacetFilterQueryClass(final String facetFilterQueryClass) {
		this.facetFilterQueryClass = facetFilterQueryClass;
	}


	/**
	 * @return the isLinkedToQueryClass
	 */
	public String getIsLinkedToQueryClass() {
		return this.isLinkedToQueryClass;
	}


	/**
	 * @param isLinkedToQueryClass
	 *            the isLinkedToQueryClass to set
	 */
	public void setIsLinkedToQueryClass(final String isLinkedToQueryClass) {
		this.isLinkedToQueryClass = isLinkedToQueryClass;
	}


	/**
	 * @return the isLinkedToFacetClass
	 */
	public String getIsLinkedToFacetClass() {
		return this.isLinkedToFacetClass;
	}


	/**
	 * @param isLinkedToFacetClass
	 *            the isLinkedToFacetClass to set
	 */
	public void setIsLinkedToFacetClass(final String isLinkedToFacetClass) {
		this.isLinkedToFacetClass = isLinkedToFacetClass;
	}


	/**
	 * @return the facetFields
	 */
	public List<String> getFacetFields() {
		return this.facetFields;
	}


	/**
	 * @param facetFields
	 *            the facetFields to set
	 */
	public void setFacetFields(final List<String> facetFields) {
		this.facetFields = facetFields;
	}


	/**
	 * @return the facetMinCount
	 */
	public int getFacetMinCount() {
		return this.facetMinCount;
	}


	/**
	 * @param facetMinCount
	 *            the facetMinCount to set
	 */
	public void setFacetMinCount(final int facetMinCount) {
		this.facetMinCount = facetMinCount;
	}


	/**
	 * @return the facetLimitNumber
	 */
	public int getFacetLimitNumber() {
		return this.facetLimitNumber;
	}


	/**
	 * @param facetLimitNumber
	 *            the facetLimitNumber to set
	 */
	public void setFacetLimitNumber(final int facetLimitNumber) {
		this.facetLimitNumber = facetLimitNumber;
	}

}