/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.dataoperator.impl;

import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.DataOperator;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.dataoperator.DeleteArgs;
import org.ow2.weblab.core.services.dataoperator.DeleteReturn;
import org.ow2.weblab.core.services.dataoperator.DropArgs;
import org.ow2.weblab.core.services.dataoperator.DropReturn;
import org.ow2.weblab.core.services.dataoperator.ReportArgs;
import org.ow2.weblab.core.services.dataoperator.ReportReturn;
import org.ow2.weblab.services.indexer.impl.SolrIndexer;

@WebService(endpointInterface="org.ow2.weblab.core.services.DataOperator")
public class SolrDataOperator
extends SolrIndexer
implements DataOperator {
    private static final Log logger = LogFactory.getLog(SolrDataOperator.class);

    public DeleteReturn delete(DeleteArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        String uri = args.getUri();
        if (uri == null) {
            logger.error((Object)"Null URI send to the Solr dataoperator");
            throw new InvalidParameterException("Uri can not be null.");
        }
        try {
            this.solr.open(this.getWebAppPath());
            this.solr.removeDocument("\"" + uri + "\"");
        }
        catch (WebLabCheckedException e) {
            logger.error((Object)e, (Throwable)e);
            throw new UnexpectedException(e.getMessage(), (Throwable)e);
        }
        return new DeleteReturn();
    }

    public DropReturn drop(DropArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        try {
            this.solr.open(this.getWebAppPath());
            this.solr.removeDocument("weblab*");
        }
        catch (WebLabCheckedException e) {
            logger.error((Object)e, (Throwable)e);
            throw new UnexpectedException(e.getMessage(), (Throwable)e);
        }
        return new DropReturn();
    }

    public ReportReturn report(ReportArgs args) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {
        throw new UnsupportedRequestException("This operation is not implemented");
    }

    @PreDestroy
    public void destroy() {
        if (this.solr != null) {
            this.solr.close();
        }
    }
}

