/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.indexer.impl;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Audio;
import org.ow2.weblab.core.model.Image;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Video;
import org.ow2.weblab.core.services.Indexer;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.indexer.IndexArgs;
import org.ow2.weblab.core.services.indexer.IndexReturn;
import org.ow2.weblab.services.solr.SolrComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.ow2.weblab.core.services.Indexer")
public class SolrIndexer
implements Indexer {
    @javax.annotation.Resource
    protected WebServiceContext wsContext;
    protected SolrComponent solr;
    private static final Log logger = LogFactory.getLog(SolrIndexer.class);

    private static MediaUnit checkArgs(IndexArgs args) throws InvalidParameterException {
        if (args == null) {
            logger.error((Object)"IndexArgs was null.");
            throw new InvalidParameterException("IndexArgs was null.", "IndexArgs was null.");
        }
        if (args.getResource() == null) {
            logger.error((Object)"Args must contain a non-null Resource to index");
            throw new InvalidParameterException("Args must contain a non-null Resource to index", "Args must contain a non-null Resource to index");
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            logger.error((Object)"Resource to index is not a MediaUnit.");
            throw new InvalidParameterException("Resource to index is not a MediaUnit.", "Resource to index is not a MediaUnit.");
        }
        return (MediaUnit)args.getResource();
    }

    @PostConstruct
    public void init() {
        this.solr = SolrComponent.getInstance();
    }

    public IndexReturn index(IndexArgs args) throws UnexpectedException, InvalidParameterException {
        MediaUnit unit = SolrIndexer.checkArgs((IndexArgs)args);
        if (unit instanceof Audio || unit instanceof Video || unit instanceof Image) {
            logger.warn((Object)("MediaUnit of type: " + unit.getClass().getSimpleName() + " cannot be indexed with Solr."));
            return new IndexReturn();
        }
        try {
            if (this.solr == null) {
                this.solr = SolrComponent.getInstance();
            }
            this.solr.open(this.getWebAppPath());
            this.solr.addDocument((Resource)unit);
        }
        catch (WebLabCheckedException e) {
            throw new UnexpectedException("Cannot open Solr index.", e.getMessage());
        }
        return new IndexReturn();
    }

    @PreDestroy
    public void destroy() {
        if (this.solr != null) {
            this.solr.close();
        }
    }

    protected String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            logger.warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        logger.debug((Object)("Webapp path = " + appPath));
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

