/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.BeanHelper;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Results;
import org.ow2.weblab.core.helper.impl.SimpleSelector;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.services.indexer.impl.SolrIndexerConfig;
import org.ow2.weblab.services.searcher.impl.SolrSearcherConfig;
import org.ow2.weblab.util.index.EntityField;
import org.ow2.weblab.util.index.Field;
import org.ow2.weblab.util.index.IndexerConfig;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolrComponent {
    private static SolrComponent singleton;
    public static final String SPRING_INDEX_CONF = "IndexerBean.xml";
    public static final String DEFAULT_HOME = "/solr";
    public static final int MINI_TEXT_SIZE = 3;
    public static final int BUFFER_DEFAULT_SIZE = 50;
    public static String home;
    private final SolrIndexerConfig indexerConfig;
    private final SolrSearcherConfig searcherConfig;
    private EmbeddedSolrServer server;
    private final Map<String, EntityField> storedEntities;
    private final int bufferSize;
    private volatile int docInBufferCounter = 0;
    private static final SimpleDateFormat solrFormat;
    private static final Log logger;
    private CoreContainer container;

    public static synchronized SolrComponent getInstance(String springConfFile, String solrHome, String beanName) {
        home = solrHome;
        if (singleton == null) {
            singleton = new SolrComponent(springConfFile, beanName);
        }
        return singleton;
    }

    public static synchronized SolrComponent getInstance(String springConfFile, String beanName) {
        if (singleton == null) {
            singleton = new SolrComponent(springConfFile, beanName);
        }
        return singleton;
    }

    public static SolrComponent getInstance() {
        return SolrComponent.getInstance((String)"IndexerBean.xml", (String)IndexerConfig.DEFAULT_BEAN_NAME);
    }

    public static SimpleDateFormat getSolrFormat() {
        return solrFormat;
    }

    private SolrComponent(String springConfFile, String beanName) {
        this.indexerConfig = (SolrIndexerConfig)BeanHelper.getInstance().getSpecificInstance(springConfFile, true).getBean(beanName, SolrIndexerConfig.class);
        this.searcherConfig = (SolrSearcherConfig)BeanHelper.getInstance().getSpecificInstance("SearcherBean.xml", true).getBean("SearcherConfig", SolrSearcherConfig.class);
        this.bufferSize = this.indexerConfig.getMinBufferSize() != 0 ? this.indexerConfig.getMinBufferSize() : 50;
        this.storedEntities = new HashMap();
        for (Map.Entry entityField : this.indexerConfig.getEntityFields().entrySet()) {
            for (String entityType : ((EntityField)entityField.getValue()).getEntityTypes()) {
                this.storedEntities.put(entityType, entityField.getValue());
            }
        }
    }

    public void open(String appPath) {
        this.open(appPath, this.indexerConfig.getSolrCoreName());
    }

    public synchronized void open(String appPath, String core) {
        if (this.server == null) {
            logger.info((Object)"Openning SOLR server...");
            File theHome = new File(appPath + home);
            if (!theHome.exists() || !theHome.isDirectory()) {
                throw new WebLabUncheckedException("SOLR home [" + theHome + "]does not exists or is not a directory.");
            }
            File f = new File(theHome, "solr.xml");
            if (!f.exists() || f.isDirectory()) {
                throw new WebLabUncheckedException("SOLR core configuration file [" + f + "]does not exists or is a directory.");
            }
            this.container = new CoreContainer();
            try {
                this.container.load(appPath + home, f);
            }
            catch (ParserConfigurationException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to erros in configuration file", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to IO error", (Throwable)e);
            }
            catch (SAXException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to XML parser error", (Throwable)e);
            }
            this.server = new EmbeddedSolrServer(this.container, core);
            logger.info((Object)"SOLR server ready for battle.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Resource toBeIndexed) throws WebLabCheckedException {
        if (toBeIndexed == null) {
            throw new WebLabCheckedException("Input Document is null.");
        }
        logger.info((Object)("Indexing Resource [" + toBeIndexed.getUri() + "]..."));
        JenaResourceHelper helper = null;
        SolrInputDocument doc = new SolrInputDocument();
        try {
            new URI(toBeIndexed.getUri());
        }
        catch (URISyntaxException urise) {
            throw new WebLabCheckedException("Resource to index does not have valid URI.", (Throwable)urise);
        }
        doc.addField("id", (Object)toBeIndexed.getUri());
        for (Map.Entry entry : this.indexerConfig.getFields().entrySet()) {
            Field field = (Field)entry.getValue();
            String fieldName = field.getName();
            if (field.isIndexTextMediaUnit()) {
                doc.addField(fieldName, (Object)SolrComponent.extractTextFromResource((Resource)toBeIndexed));
            }
            if (field.getProperties() == null || field.getProperties().size() <= 0) continue;
            if (helper == null) {
                helper = new JenaResourceHelper(toBeIndexed);
            }
            ArrayList predList = new ArrayList();
            for (String property : field.getProperties()) {
                predList.addAll(helper.getLitsOnPredSubj(toBeIndexed.getUri(), property));
                predList.addAll(helper.getRessOnPredSubj(toBeIndexed.getUri(), property));
            }
            boolean bl = false;
            for (String p : predList) {
                boolean bl2;
                if (field.getType().equals("date") && !bl2) {
                    try {
                        Date date = DateUtils.parseDate((String)p, (String[])IndexerConfig.DATE_FORMATS);
                        String solrDate = solrFormat.format(date);
                        doc.addField(fieldName, (Object)solrDate);
                        bl2 = true;
                    }
                    catch (ParseException pe) {
                        logger.debug((Object)("Unable to parse date : " + p));
                    }
                    continue;
                }
                doc.addField(fieldName, (Object)p);
                logger.debug((Object)("add field: " + fieldName + " = " + p));
            }
        }
        SimpleSelector selector = RDFSelectorFactory.getSelector();
        selector.limitToFirstLevelAnnotation(false);
        Results stats = selector.select(toBeIndexed, new String[0]);
        List mediaUnitList = ResourceUtil.getSelectedSubResources((Resource)toBeIndexed, MediaUnit.class);
        ArrayList<LinearSegment> linearSegmentList = new ArrayList<LinearSegment>();
        for (MediaUnit mediaUnit : mediaUnitList) {
            for (Segment seg : mediaUnit.getSegment()) {
                if (!(seg instanceof LinearSegment)) continue;
                linearSegmentList.add((LinearSegment)seg);
            }
        }
        for (LinearSegment linearSegment : linearSegmentList) {
            for (String entityUri : stats.getTypedValues(linearSegment.getUri(), "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo", String.class)) {
                HashSet types = new HashSet(stats.getTypedValues(entityUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", String.class));
                types.retainAll(this.storedEntities.keySet());
                for (String type : types) {
                    block18: for (Map.Entry entityField : this.indexerConfig.getEntityFields().entrySet()) {
                        if (!((EntityField)entityField.getValue()).getEntityTypes().contains(type)) continue;
                        for (String labelUri : ((EntityField)entityField.getValue()).getLabelProperties()) {
                            HashSet labels = new HashSet(stats.getTypedValues(entityUri, labelUri, String.class));
                            if (labels.size() > 1) {
                                logger.warn((Object)("More than one label found for entity " + entityUri + ", use first."));
                            }
                            if (labels.size() <= 0) {
                                logger.warn((Object)("No labels found for entity " + entityUri + ", will not be stored."));
                                continue;
                            }
                            String fieldName = ((EntityField)this.storedEntities.get(type)).getName();
                            String label = (String)labels.iterator().next();
                            logger.debug((Object)("Add entity field : " + fieldName + " = " + label));
                            doc.addField(fieldName, (Object)label);
                            continue block18;
                        }
                    }
                }
            }
        }
        for (Map.Entry entry : this.indexerConfig.getEntityFields().entrySet()) {
            for (String entityType : ((EntityField)entry.getValue()).getEntityTypes()) {
                if (helper == null) {
                    helper = new JenaResourceHelper(toBeIndexed);
                }
                ArrayList predList = new ArrayList();
                predList.addAll(helper.getLitsOnPredSubj(toBeIndexed.getUri(), entityType));
                predList.addAll(helper.getRessOnPredSubj(toBeIndexed.getUri(), entityType));
                for (String p : predList) {
                    doc.addField(((EntityField)entry.getValue()).getName(), (Object)p);
                    logger.debug((Object)("Add entity field : " + ((EntityField)entry.getValue()).getName() + " = " + p));
                }
            }
        }
        SolrComponent solrComponent = this;
        synchronized (solrComponent) {
            try {
                this.server.add(doc);
                ++this.docInBufferCounter;
                logger.info((Object)("Resource [" + toBeIndexed.getUri() + "] added to the indexing buffer."));
            }
            catch (IOException iOException) {
                throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)iOException);
            }
            catch (SolrServerException solrServerException) {
                throw new WebLabCheckedException("Server error while adding documents", (Throwable)solrServerException);
            }
            if (this.docInBufferCounter >= this.bufferSize) {
                this.flushIndexBuffer();
            }
        }
    }

    public static String extractTextFromResource(Resource res) {
        Text t;
        StringBuffer concatenationOfText = new StringBuffer();
        if (res instanceof Document) {
            List textList = ResourceUtil.getSelectedSubResources((Resource)res, Text.class);
            for (Text t2 : textList) {
                if (t2.getContent() == null || t2.getContent().length() <= 3) continue;
                concatenationOfText.append(t2.getContent().trim() + "\n");
            }
        } else if (res instanceof Text && (t = (Text)res).getContent() != null && t.getContent().length() > 3) {
            concatenationOfText.append(t.getContent().trim() + "\n");
        }
        return concatenationOfText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.server != null && this.container != null) {
            try {
                logger.info((Object)"Closing SOLR server...");
                if (this.docInBufferCounter > 0) {
                    this.flushIndexBuffer();
                }
                this.server.optimize();
            }
            catch (WebLabCheckedException e) {
                logger.error((Object)"Cannot flush the index indexing buffer properly.", (Throwable)e);
                throw new WebLabUncheckedException("Cannot flush the index indexing buffer properly.", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebLabUncheckedException("I/O access error while optimizing the index.", (Throwable)e);
            }
            catch (SolrServerException e) {
                logger.warn((Object)"Cannot optimize the index properly.", (Throwable)e);
            }
            finally {
                this.container.shutdown();
                this.container = null;
                this.server = null;
                logger.info((Object)"SOLR server closed.");
            }
        }
    }

    public void flushIndexBuffer() throws WebLabCheckedException {
        try {
            this.server.commit();
            this.docInBufferCounter = 0;
            logger.info((Object)"Indexing buffer flushed.");
        }
        catch (SolrServerException e) {
            throw new WebLabCheckedException("Server error while adding documents", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)e);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public QueryResponse search(String queryString, int offset, int limit) throws WebLabCheckedException {
        QueryResponse response;
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("start", new String[]{String.valueOf(offset)});
            query.setParam("rows", new String[]{String.valueOf(limit)});
            if (this.searcherConfig.getFacetFields().size() > 0) {
                query.setFacet(true);
                query.setFacetMinCount(this.searcherConfig.getFacetMinCount());
                query.setFacetLimit(this.searcherConfig.getFacetLimitNumber());
                for (String facetFieldName : this.searcherConfig.getFacetFields()) {
                    query.addFacetField(new String[]{facetFieldName});
                }
            }
            if (this.searcherConfig.isHitsEnrichedWithMetas()) {
                query.setParam("qt", new String[]{"weblab_with_meta"});
            } else {
                query.setParam("qt", new String[]{"weblab"});
            }
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                logger.error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            response = new QueryResponse();
        }
        return response;
    }

    public QueryResponse moreLikeThis(String queryString) throws WebLabCheckedException {
        QueryResponse response;
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQueryType("mlt");
            query.set("mlt", new String[0]);
            query.set("mlt.match.include", false);
            query.set("mlt.mindf", 1);
            query.set("mlt.mintf", 1);
            query.set("mlt.fl", new String[]{"source,title,text"});
            query.setQuery(queryString);
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                logger.error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            response = new QueryResponse();
        }
        return response;
    }

    public static void setHome(String home) {
        SolrComponent.home = home;
    }

    public static String getHome() {
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(String uri) throws WebLabCheckedException {
        SolrComponent solrComponent = this;
        synchronized (solrComponent) {
            try {
                this.server.deleteByQuery("id:" + uri);
                logger.info((Object)("Resource [" + uri + "] removed."));
            }
            catch (IOException e) {
                throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)e);
            }
            catch (SolrServerException e) {
                throw new WebLabCheckedException("Server error while adding documents", (Throwable)e);
            }
        }
    }

    static {
        home = "/solr";
        solrFormat = new SimpleDateFormat("yyyy-MM-dd");
        logger = LogFactory.getLog(SolrComponent.class);
    }
}

