/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.searcher.impl;

import java.util.Map;

import org.ow2.weblab.util.index.Field;
import org.ow2.weblab.util.search.SearcherConfig;


public class SolrSearcherConfig extends SearcherConfig {

	/**
	 * Default id reference
	 */
	public static final String DEFAULT_IDREF = "eads.indexsearch.solr";

	/**
	 * Default id result
	 */
	public static final String DEFAULT_IDRES = "result";

	/**
	 * default name for configuration file
	 */
	public static final String DEFAULT_CONF_FILE = "SearcherBean.xml";
	
	/**
	 * Indicate if hits are enriched with meta presents in index
	 */
	protected boolean hitsEnrichedWithMetas;
	
	/**
	 * Map of ResultSet labels, key corresponding local and value the label
	 * for this local
	 */
	protected Map<String, String> resultSetLabels;
	
	/**
	 * @return the resultSetLabels
	 */
	public Map<String, String> getResultSetLabels() {
		return this.resultSetLabels;
	}

	/**
	 * @param resultSetLabels the resultSetLabels to set
	 */
	public void setResultSetLabels(final Map<String, String> resultSetLabels) {
		this.resultSetLabels = resultSetLabels;
	}

	/**
	 * List of fields to retrieve in POK if hit enrichment is activated
	 */
	protected Map<String, Field> fieldsToRetrieve;
	
	/**
	 * @return the hitsEnrichedWithMetas
	 */
	public boolean isHitsEnrichedWithMetas() {
		return this.hitsEnrichedWithMetas;
	}

	/**
	 * @param hitsEnrichedWithMetas the hitsEnrichedWithMetas to set
	 */
	public void setHitsEnrichedWithMetas(final boolean hitsEnrichedWithMetas) {
		this.hitsEnrichedWithMetas = hitsEnrichedWithMetas;
	}

	/**
	 * @return the fieldsToRetrieve
	 */
	public Map<String, Field> getFieldsToRetrieve() {
		return this.fieldsToRetrieve;
	}

	/**
	 * @param fieldsToRetrieve the fieldsToRetrieve to set
	 */
	public void setFieldsToRetrieve(final Map<String, Field> fieldsToRetrieve) {
		this.fieldsToRetrieve = fieldsToRetrieve;
	}

}
