/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.index;

import java.util.List;

public class EntityField {


	/**
	 * Name of the field in the index
	 */
	protected String name;


	/**
	 * Field type : should be text, number, date
	 */
	protected String type;


	/**
	 * List of entityTypes indexed in this field
	 */
	protected List<String> entityTypes;


	/**
	 * List of entityLabels indexed in this field
	 */
	protected List<String> labelProperties;



	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}


	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(final String name) {
		this.name = name;
	}


	/**
	 * @return the type
	 */
	public String getType() {
		return this.type;
	}


	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(final String type) {
		this.type = type;
	}


	/**
	 * @return the entityTypes
	 */
	public List<String> getEntityTypes() {
		return this.entityTypes;
	}


	/**
	 * @param properties
	 *            The properties
	 */
	public void setEntityTypes(final List<String> properties) {
		this.entityTypes = properties;
	}


	public List<String> getLabelProperties() {
		return this.labelProperties;
	}


	public void setLabelProperties(final List<String> labelProperties) {
		this.labelProperties = labelProperties;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + ((this.entityTypes == null) ? 0 : this.entityTypes.hashCode());
		result = (prime * result) + ((this.labelProperties == null) ? 0 : this.labelProperties.hashCode());
		result = (prime * result) + ((this.name == null) ? 0 : this.name.hashCode());
		result = (prime * result) + ((this.type == null) ? 0 : this.type.hashCode());
		return result;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		final EntityField other = (EntityField) obj;
		if (this.entityTypes == null) {
			if (other.entityTypes != null) {
				return false;
			}
		} else if (!this.entityTypes.equals(other.entityTypes)) {
			return false;
		}

		if (this.labelProperties == null) {
			if (other.labelProperties != null) {
				return false;
			}
		} else if (!this.labelProperties.equals(other.labelProperties)) {
			return false;
		}

		if (this.name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!this.name.equals(other.name)) {
			return false;
		}

		if (this.type == null) {
			if (other.type != null) {
				return false;
			}
		} else if (!this.type.equals(other.type)) {
			return false;
		}
		return true;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "EntityField [entityTypes=" + this.entityTypes + ", name=" + this.name + ", type=" + this.type + ", labelsProperties=" + this.labelProperties
				+ "]";
	}

}
