/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.searcher.impl;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.BeanHelper;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.services.searcher.impl.SolrSearcherConfig;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.util.index.Field;

@WebService(endpointInterface="org.ow2.weblab.core.services.Searcher")
public class SolrSearcher
implements Searcher {
    @javax.annotation.Resource
    protected WebServiceContext wsContext;
    private static int resultsCpt = 0;
    private final SolrSearcherConfig conf = (SolrSearcherConfig)BeanHelper.getInstance().getSpecificInstance("SearcherBean.xml", true).getBean("SearcherConfig", SolrSearcherConfig.class);
    private final SolrComponent solrComponent = SolrComponent.getInstance();
    private static final Log logger = LogFactory.getLog(SolrSearcher.class);

    @PreDestroy
    public void destroy() {
        if (this.solrComponent != null) {
            this.solrComponent.close();
        }
    }

    public SearchReturn search(SearchArgs arg0) throws InvalidParameterException {
        Query q = arg0.getQuery();
        int offset = arg0.getOffset() != null && arg0.getOffset() > 0 ? arg0.getOffset() : 0;
        int limit = arg0.getLimit() != null && arg0.getLimit() > 0 ? arg0.getLimit() : 10;
        SearchReturn re = new SearchReturn();
        re.setResultSet(this.search(q, offset, limit));
        return re;
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet search(Query q, int offset, int limit) throws InvalidParameterException {
        StringQuery query = null;
        if (!(q instanceof StringQuery)) {
            throw new InvalidParameterException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + ".", "Input has invalid type:" + q.getClass() == null ? " no xsi:type !" : q.getClass().getSimpleName());
        }
        query = (StringQuery)q;
        try {
            logger.debug((Object)("query request : " + query.getRequest()));
            logger.debug((Object)("Query input : " + ResourceUtil.saveToXMLString((Resource)query)));
        }
        catch (WebLabCheckedException e) {
            logger.debug((Object)"Error when logging query input", (Throwable)e);
        }
        SearchReturn returnedResults = new SearchReturn();
        ResultSet results = (ResultSet)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("result" + resultsCpt++), ResultSet.class);
        PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("pok" + resultsCpt++), PieceOfKnowledge.class);
        results.setPok(pok);
        JenaPoKHelper h = new JenaPoKHelper(pok);
        h.setAutoCommitMode(false);
        returnedResults.setResultSet(results);
        for (String string : this.conf.getNsPrefixProperties().keySet()) {
            h.setNSPrefix(string, (String)this.conf.getNsPrefixProperties().get(string));
        }
        h.createResStat(results.getUri(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/model#ResultSet");
        h.createResStat(results.getUri(), (String)this.conf.getProperties().get("isResultOf"), q.getUri());
        for (Map.Entry entry : this.conf.getResultSetLabels().entrySet()) {
            h.createLitStat(results.getUri(), "http://www.w3.org/2000/01/rdf-schema#label", (String)entry.getValue(), (String)entry.getKey());
        }
        try {
            this.solrComponent.open(this.getWebAppPath());
            QueryResponse res = this.solrComponent.search(query.getRequest(), offset, limit);
            boolean bl = false;
            SolrDocumentList resultDocs = res.getResults();
            Map highlightings = res.getHighlighting();
            if (resultDocs != null) {
                for (SolrDocument hit : resultDocs) {
                    void var10_16;
                    String resourceUri = String.valueOf(hit.getFieldValue("id"));
                    String hitUri = "weblab://eads.indexsearch.solr/hit" + (int)var10_16;
                    h.createResStat(results.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasHit", hitUri);
                    h.createResStat(hitUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getHitClass());
                    h.createLitStat(hitUri, (String)this.conf.getProperties().get("hasRank"), String.valueOf(offset + var10_16 + 1));
                    h.createLitStat(hitUri, (String)this.conf.getProperties().get("hasScore"), String.valueOf(hit.getFieldValue("score")));
                    if (highlightings != null && ((Map)highlightings.get(hit.getFieldValue("id"))).size() > 0) {
                        List hitHighlightingList = (List)((Map)highlightings.get(hit.getFieldValue("id"))).get("text");
                        StringBuffer snippet = new StringBuffer();
                        for (String hl : hitHighlightingList) {
                            snippet.append(hl);
                        }
                        h.createLitStat(hitUri, (String)this.conf.getProperties().get("hasDescription"), snippet.toString());
                    }
                    h.createResStat(hitUri, (String)this.conf.getProperties().get("isLinkedTo"), resourceUri);
                    h.createResStat(hitUri, (String)this.conf.getProperties().get("inResultSet"), results.getUri());
                    if (this.conf.isHitsEnrichedWithMetas()) {
                        Map fields = hit.getFieldValuesMap();
                        for (Map.Entry confField : this.conf.getFieldsToRetrieve().entrySet()) {
                            Field field = (Field)confField.getValue();
                            if (!fields.containsKey(field.getName())) continue;
                            for (String property : field.getProperties()) {
                                Collection fieldValues = (Collection)fields.get(field.getName());
                                for (Object fieldValue : fieldValues) {
                                    if (fieldValue instanceof String) {
                                        if (field.getType().equals("URI")) {
                                            h.createResStat(resourceUri, property, ((String)fieldValue).trim());
                                            continue;
                                        }
                                        h.createLitStat(resourceUri, property, ((String)fieldValue).trim());
                                        continue;
                                    }
                                    if (!(fieldValue instanceof Date)) continue;
                                    h.createLitStat(resourceUri, property, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format((Date)fieldValue));
                                }
                            }
                        }
                    }
                    ++var10_16;
                }
                h.createLitStat(results.getUri(), (String)this.conf.getProperties().get("hasNumberOfResults"), String.valueOf(resultDocs.getNumFound()));
            } else {
                h.createLitStat(results.getUri(), (String)this.conf.getProperties().get("hasNumberOfResults"), "0");
            }
            h.createLitStat(results.getUri(), (String)this.conf.getProperties().get("offset"), String.valueOf(offset));
            if (this.conf.getFacetFields().size() > 0) {
                int facetCpt = 0;
                for (String facetFieldName : this.conf.getFacetFields()) {
                    List countList;
                    String facetUri = "weblab://eads.indexsearch.solrfacet" + resultsCpt + "_" + facetCpt++;
                    h.createResStat(facetUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getFacetClass());
                    h.createLitStat(facetUri, "http://www.w3.org/2000/01/rdf-schema#label", facetFieldName);
                    h.createResStat(facetUri, this.conf.getIsLinkedToQueryClass(), q.getUri());
                    FacetField ff = res.getFacetField(facetFieldName);
                    if (ff == null || (countList = ff.getValues()) == null) continue;
                    int facetValueCpt = 0;
                    for (FacetField.Count count : countList) {
                        logger.debug((Object)("Create facet element: " + facetFieldName + "=" + count.getName() + "(" + count.getCount() + ")"));
                        String facetValueUri = "weblab://eads.indexsearch.solrfacetValue" + resultsCpt + "_" + facetCpt + "_" + facetValueCpt++;
                        h.createResStat(facetValueUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getFacetValueClass());
                        h.createLitStat(facetValueUri, "http://www.w3.org/2000/01/rdf-schema#label", count.getName());
                        h.createLitStat(facetValueUri, this.conf.getFacetCountClass(), String.valueOf(count.getCount()));
                        h.createLitStat(facetValueUri, this.conf.getFacetFilterQueryClass(), count.getAsFilterQuery());
                        h.createResStat(facetValueUri, this.conf.getIsLinkedToFacetClass(), facetUri);
                    }
                }
            }
            h.commit();
        }
        catch (WebLabCheckedException wlce) {
            throw new InvalidParameterException("Cannot retrieve the results to query [" + query.getRequest() + "] - " + wlce.getMessage(), (Throwable)wlce);
        }
        return results;
    }

    protected String getWebAppPath() throws WebLabCheckedException {
        String appPath = null;
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            logger.warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        if (appPath == null) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] is null...");
        }
        if (!new File(appPath).exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

