/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;

public class SolrComponent {
    private static final String QUERY_HANDLER_MINIMAL = "weblab";
    private static final String QUERY_HANDLER_META = "weblab_meta";
    private static final String QUERY_HANDLER_HIGHLIGHT = "weblab_highlight";
    private static final String QUERY_HANDLER_FACET = "weblab_facet";
    private static final String QUERY_HANDLER_SPELL = "weblab_spell";
    private static final String QUERY_HANDLER_MORE = "weblab_more";
    public static final String IDREF = "indexsearch.solr";
    public static final String IDRES_RESULT_PREFIX = "result";
    public static final String IDRES_QUERY_PREFIX = "query";
    public static final String IDRES_HIT_PREFIX = "hit";
    public static final String DEFAULT_CORE_PREFIX = "core";
    protected static String SOLR_HOME = ".";
    protected static String SOLR_CONFIG = "/conf/solrconfig.xml";
    protected static String SOLR_SCHEMA = "/conf/schema.xml";
    protected static String SOLR_DATA_HOME = SOLR_HOME;
    private static final Log LOGGER = LogFactory.getLog(SolrComponent.class);
    private static final int MIN_TEXT_CONTENT_SIZE = 3;
    private static SolrComponent defaultInstance;
    private static Map<String, SolrComponent> instancesByContext;
    private String solrURL;
    private String coreDataHome;
    private String coreName;
    private SolrServer server;
    private int nbDocSinceLastFlush = 0;

    public static synchronized SolrComponent getInstance(String solrURL, String context) {
        if (context == null) {
            if (defaultInstance == null) {
                new SolrComponent(solrURL, null);
            }
            return defaultInstance;
        }
        if (!instancesByContext.containsKey(context)) {
            new SolrComponent(solrURL, context);
        }
        return (SolrComponent)instancesByContext.get(context);
    }

    public static synchronized void deleteInstance(String context) {
        throw new NotImplementedException("Instance deletion is not yet implemented. The current solution is to do it manually on the server.");
    }

    public static String extractTextFromResource(MediaUnit res) {
        Text t;
        StringBuffer concatenationOfText = new StringBuffer();
        if (res instanceof Document) {
            List textList = ResourceUtil.getSelectedSubResources((Resource)res, Text.class);
            for (Text t2 : textList) {
                if (t2.getContent() == null || t2.getContent().length() <= 3) continue;
                concatenationOfText.append(t2.getContent().trim() + "\n");
            }
        } else if (res instanceof Text && (t = (Text)res).getContent() != null && t.getContent().length() > 3) {
            concatenationOfText.append(t.getContent().trim() + "\n");
        }
        return concatenationOfText.toString();
    }

    private SolrComponent(String solrURL, String context) {
        new SolrComponent(solrURL, SOLR_DATA_HOME, context);
    }

    private SolrComponent(String solrURL, String solrDataHome, String context) {
        try {
            this.coreName = DEFAULT_CORE_PREFIX + (context == null ? "-default" : "" + context.hashCode());
            this.solrURL = solrURL;
            this.coreDataHome = !solrDataHome.endsWith(File.separator) ? solrDataHome + File.separator + this.coreName + File.separator : solrDataHome + this.coreName + File.separator;
            this.createCore();
            this.open();
            LOGGER.info((Object)("SolR [" + this.getCoreName() + "] is ready to serve my lord !"));
        }
        catch (IOException e) {
            throw new WebLabUncheckedException("Cannot create SolR [" + this.getCoreName() + "]. Check the logs", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new WebLabUncheckedException("Cannot create SolR [" + this.getCoreName() + "]. Check the logs", (Throwable)e);
        }
        if (context == null) {
            defaultInstance = this;
        } else {
            instancesByContext.put(context, this);
        }
    }

    private void createCore() throws SolrServerException, IOException {
        CoreAdminRequest statusRequest = new CoreAdminRequest();
        statusRequest.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        NamedList res = new CommonsHttpSolrServer(new URL(this.solrURL)).request((SolrRequest)statusRequest);
        if ((Integer)((NamedList)res.get("responseHeader")).get("status") != 0) {
            throw new WebLabUncheckedException("Cannot get Solr server sattus. Check the logs.");
        }
        NamedList status = (NamedList)res.get("status");
        NamedList coreStatus = (NamedList)status.get(this.getCoreName());
        if (coreStatus != null) {
            LOGGER.debug((Object)("Using existing configuration for SolR [" + this.getCoreName() + "]."));
        } else {
            LOGGER.debug((Object)("Creating SolR [" + this.getCoreName() + "]..."));
            CoreAdminRequest.Create createRequest = new CoreAdminRequest.Create();
            createRequest.setCoreName(this.getCoreName());
            createRequest.setInstanceDir(SOLR_HOME);
            createRequest.setDataDir(this.getCoreDataHome());
            createRequest.setConfigName(SOLR_HOME + SOLR_CONFIG);
            createRequest.setSchemaName(SOLR_HOME + SOLR_SCHEMA);
            res = new CommonsHttpSolrServer(new URL(this.solrURL)).request((SolrRequest)createRequest);
            if ((Integer)((NamedList)res.get("responseHeader")).get("status") != 0) {
                throw new WebLabUncheckedException("Cannot create SolR [" + this.getCoreName() + "]. Check the logs.");
            }
            LOGGER.debug((Object)("SolR [" + this.getCoreName() + "] ready to be used."));
        }
    }

    private void open() {
        try {
            LOGGER.debug((Object)"Connecting to SOLR server...");
            this.server = new CommonsHttpSolrServer(new URL(this.getSolrURL() + this.getCoreName()));
            LOGGER.debug((Object)"SolR client is connected to the server.");
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Solr server URL is not valid [" + this.getSolrURL() + this.getCoreName() + "].", (Throwable)e);
        }
    }

    public String getStatus() {
        CoreAdminRequest statusRequest = new CoreAdminRequest();
        statusRequest.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        statusRequest.setCoreName(this.getCoreName());
        try {
            NamedList status = new CommonsHttpSolrServer(new URL(this.solrURL)).request((SolrRequest)statusRequest);
            return status.toString();
        }
        catch (IOException e) {
            throw new WebLabUncheckedException("Error while requesting SolR [" + this.getCoreName() + "] status.", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new WebLabUncheckedException("Error while requesting SolR [" + this.getCoreName() + "] status.", (Throwable)e);
        }
    }

    public void addDocument(SolrInputDocument doc) throws WebLabCheckedException {
        if (doc.getField("id") == null) {
            throw new WebLabCheckedException("Document to index does not have valid ID.");
        }
        LOGGER.debug((Object)("Indexing document [" + doc.getField("id") + "]..."));
        try {
            this.server.add(doc);
            ++this.nbDocSinceLastFlush;
            LOGGER.debug((Object)("Resource [" + doc.getField("id") + "] added to the indexing buffer."));
        }
        catch (IOException e) {
            throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new WebLabCheckedException("Server error while adding documents", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.server != null) {
            try {
                LOGGER.info((Object)"Commiting last update on SolR server...");
                if (this.nbDocSinceLastFlush > 0) {
                    this.server.commit();
                    this.nbDocSinceLastFlush = 0;
                    LOGGER.info((Object)"Indexing buffer flushed.");
                }
                this.server.optimize();
            }
            catch (IOException e) {
                throw new WebLabUncheckedException("I/O access error while optimizing the index.", (Throwable)e);
            }
            catch (SolrServerException e) {
                LOGGER.warn((Object)"Cannot optimize the index properly.", (Throwable)e);
            }
            finally {
                LOGGER.info((Object)"Commit done.");
            }
        }
    }

    public QueryResponse search(String queryString, int offset, int limit) throws WebLabCheckedException {
        QueryResponse response = new QueryResponse();
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("start", new String[]{String.valueOf(offset)});
            query.setParam("rows", new String[]{String.valueOf(limit)});
            query.setParam("qt", new String[]{QUERY_HANDLER_MINIMAL});
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LOGGER.error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            LOGGER.warn((Object)"The last query is empty dude ! WHat do you want me to do ?");
        }
        return response;
    }

    public QueryResponse getMetaData(String ... uri) throws WebLabCheckedException {
        QueryResponse response = new QueryResponse();
        StringBuilder buf = new StringBuilder();
        buf.append("id:(");
        String or = " OR ";
        for (int k = 0; k < uri.length; ++k) {
            String docURI = uri[k];
            buf.append('\"');
            buf.append(docURI);
            buf.append('\"');
            if (k == uri.length - 1) continue;
            buf.append(or);
        }
        buf.append(")");
        SolrQuery query = new SolrQuery();
        query.setQuery(buf.toString());
        query.setParam("start", new String[]{"0"});
        query.setParam("rows", new String[]{String.valueOf(uri.length)});
        query.setParam("qt", new String[]{QUERY_HANDLER_META});
        try {
            response = this.server.query((SolrParams)query);
        }
        catch (SolrServerException sse) {
            LOGGER.error((Object)"Cannot post search request", (Throwable)sse);
            throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
        }
        return response;
    }

    public QueryResponse highlight(String queryString, int offset, int limit) throws WebLabCheckedException {
        QueryResponse response = new QueryResponse();
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("start", new String[]{String.valueOf(offset)});
            query.setParam("rows", new String[]{String.valueOf(limit)});
            query.setParam("qt", new String[]{QUERY_HANDLER_HIGHLIGHT});
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LOGGER.error((Object)"Cannot post highlight request", (Throwable)sse);
            }
        } else {
            LOGGER.warn((Object)"The input query is empty. Cannot highlight search results. What do you want me to do ?");
        }
        return response;
    }

    public QueryResponse spellSuggest(String queryString) {
        QueryResponse response = new QueryResponse();
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("qt", new String[]{QUERY_HANDLER_SPELL});
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LOGGER.error((Object)"Cannot post spell suggest request", (Throwable)sse);
            }
        } else {
            LOGGER.warn((Object)"The input query is empty. Cannot make spell suggestion.");
        }
        return response;
    }

    public QueryResponse facetSuggest(String queryString, int offset, int limit) {
        QueryResponse response = new QueryResponse();
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("qt", new String[]{QUERY_HANDLER_FACET});
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LOGGER.error((Object)"Cannot post spell suggest request", (Throwable)sse);
            }
        } else {
            LOGGER.warn((Object)"The input query is empty. Cannot make spell suggestion.");
        }
        return response;
    }

    public QueryResponse moreLikeThis(String queryString) throws WebLabCheckedException {
        QueryResponse response = new QueryResponse();
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setParam("qt", new String[]{QUERY_HANDLER_MORE});
            query.setQueryType("mlt");
            query.set("mlt", new String[0]);
            query.set("mlt.match.include", false);
            query.set("mlt.mindf", 1);
            query.set("mlt.mintf", 1);
            query.set("mlt.fl", new String[]{"source,title,text"});
            query.setQuery(queryString);
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LOGGER.error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            LOGGER.warn((Object)"The input query is empty. Cannot make a 'moreLikeThis' query.");
        }
        return response;
    }

    public String getCoreName() {
        return this.coreName;
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = !solrURL.endsWith(File.separator) ? solrURL + File.separator : solrURL;
    }

    public String getCoreDataHome() {
        return this.coreDataHome;
    }

    public void setCoreDataHome(String coreDataHome) {
        this.coreDataHome = !(coreDataHome = new File(coreDataHome).getAbsolutePath()).endsWith(File.separator) ? coreDataHome + File.separator : coreDataHome;
    }

    static {
        instancesByContext = new HashMap();
    }
}

