/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.searcher;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.PoKFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.analyser.FacetSuggestion;
import org.ow2.weblab.services.solr.analyser.Highlighter;
import org.ow2.weblab.services.solr.analyser.ResultSetMetadataEnrichment;

@WebService(endpointInterface="org.ow2.weblab.core.services.Searcher")
public class SolrSearcher
implements Searcher {
    public static final String BEAN_NAME = "searcherServiceBean";
    private static int resultsCounter = 0;
    private static int hitCounter = 0;
    private Log logger;
    private String solrURL;
    private ResultSetMetadataEnrichment enricher;
    private Highlighter highlighter;
    private FacetSuggestion facetSuggestion;
    private boolean noCore = false;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(SolrSearcher.class);
        try {
            new URL(this.solrURL);
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.solrURL + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
    }

    public SearchReturn search(SearchArgs arg) throws InvalidParameterException, ServiceNotConfiguredException, UnexpectedException {
        Query q = arg.getQuery();
        Integer offset = arg.getOffset() != null && arg.getOffset() > 0 ? arg.getOffset() : new Integer(0);
        Integer limit = arg.getLimit() != null && arg.getLimit() > 0 ? arg.getLimit() : Integer.valueOf(10);
        ResultSet set = this.search(arg.getUsageContext(), q, offset.intValue(), limit.intValue());
        if (this.enricher != null) {
            set = this.enricher.addMetadataToResultSet(arg.getUsageContext(), set);
        }
        if (this.highlighter != null) {
            set = this.highlighter.highLightHitInResultSet(arg.getUsageContext(), set);
        }
        if (this.facetSuggestion != null) {
            set = this.facetSuggestion.doFacetSuggest(arg.getUsageContext(), set);
        }
        SearchReturn re = new SearchReturn();
        re.setResultSet(set);
        return re;
    }

    public ResultSet search(String context, Query q, int offset, int limit) throws InvalidParameterException, ServiceNotConfiguredException, UnexpectedException {
        StringQuery query = null;
        if (!(q instanceof StringQuery)) {
            throw new InvalidParameterException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + ".", "Input has invalid type:" + q.getClass() == null ? " no xsi:type !" : q.getClass().getSimpleName());
        }
        query = (StringQuery)q;
        try {
            this.logger.debug((Object)("query request : " + query.getRequest()));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Query input : " + ResourceUtil.saveToXMLString((Resource)query)));
            }
        }
        catch (WebLabCheckedException e) {
            this.logger.debug((Object)"Error when logging query input", (Throwable)e);
        }
        try {
            SolrComponent instance = this.noCore ? SolrComponent.getInstance((String)this.solrURL, null) : SolrComponent.getInstance((String)this.solrURL, (String)context);
            QueryResponse res = instance.search(query.getRequest(), offset, limit);
            SolrDocumentList resultDocs = res.getResults();
            int resCpt = 0;
            ResultSet results = (ResultSet)ResourceFactory.createResource((String)"indexsearch.solr", (String)("result" + resultsCounter++), ResultSet.class);
            results.getResource().add(query);
            URI queryURI = new URI(query.getUri());
            PieceOfKnowledge pok = PoKFactory.createAndLinkPoK((ResultSet)results);
            results.setPok(pok);
            WRetrievalAnnotator wra = new WRetrievalAnnotator(new URI(results.getUri()), pok);
            wra.writeType(new URI("http://weblab.ow2.org/core/1.2/ontology/model#ResultSet"));
            wra.writeResultOf(queryURI);
            wra.writeExpectedOffset(Integer.valueOf(offset));
            wra.writeExpectedLimit(Integer.valueOf(limit));
            wra.writeNumberOfResults(Integer.valueOf((int)resultDocs.getNumFound()));
            if (resultDocs == null || resultDocs.getNumFound() == 0L) {
                wra.writeNumberOfResults(Integer.valueOf(0));
            } else {
                for (SolrDocument hit : resultDocs) {
                    URI resourceUri = new URI(String.valueOf(hit.getFieldValue("id")));
                    URI hitUri = new URI("weblab://indexsearch.solr/hit" + hitCounter++);
                    wra.writeHit(hitUri);
                    wra.startInnerAnnotatorOn(hitUri);
                    wra.writeType(new URI("http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"));
                    wra.writeRank(Integer.valueOf(offset + resCpt + 1));
                    wra.writeScore(Double.valueOf(0.0 + (double)((Float)hit.getFieldValue("score")).floatValue()));
                    wra.writeLinkedTo(resourceUri);
                    wra.endInnerAnnotator();
                    ++resCpt;
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Results input : " + ResourceUtil.saveToXMLString((Resource)results)));
            }
            return results;
        }
        catch (WebLabCheckedException e) {
            throw new InvalidParameterException("Cannot retrieve the results to query [" + query.getRequest() + "] - " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new UnexpectedException("Invalid URI encountered during RDF annotation. That's really strange isn't it ?", (Throwable)e);
        }
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = solrURL;
    }

    public ResultSetMetadataEnrichment getEnricher() {
        return this.enricher;
    }

    public void setEnricher(ResultSetMetadataEnrichment enricher) {
        this.enricher = enricher;
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    public FacetSuggestion getFacetSuggestion() {
        return this.facetSuggestion;
    }

    public void setFacetSuggestion(FacetSuggestion facetSuggestion) {
        this.facetSuggestion = facetSuggestion;
    }

    public boolean isNoCore() {
        return this.noCore;
    }

    public void setNoCore(boolean noCore) {
        this.noCore = noCore;
    }
}

