/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.solr.indexer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ow2.weblab.util.index.Field;

public class SolrIndexerConfig {
	public static final String ID_FIELD = "id";
	public static final String ID_TEXT = "text";
	public final static String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

	/**
	 * Util map to get field name based on property URI indexed. Watch out: the
	 * map is loaded only through setFields() method (ie on loading from conf
	 * file) but is not synchronized later on if the field list is changed.
	 */
	private Map<String, String> propertyToFieldMap = new HashMap<String, String>();

	/**
	 * Fields used by the index
	 */
	private List<Field> fields;

	public List<Field> getFields() {
		return fields;
	}

	public void setFields(List<Field> fields) {
		this.fields = fields;

		if (fields != null) {
			for (Field f : fields) {
				if (f.getProperties() != null) {
					for (String property : f.getProperties()) {
						propertyToFieldMap.put(property, f.getName());
					}
				}
			}
		}
	}

	public Map<String, String> getPropertyToFieldMap() {
		return propertyToFieldMap;
	}

	public void setPropertyToFieldMap(Map<String, String> propertyToFieldMap) {
		this.propertyToFieldMap = propertyToFieldMap;
	}
}
