/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.analyser;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.searcher.SolrSearcher;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class Highlighter
implements Analyser {
    public static final String BEAN_NAME = "highlighterServiceBean";
    private Log logger;
    private String solrURL;
    private boolean noCore = false;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(SolrSearcher.class);
        try {
            new URL(this.solrURL);
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.solrURL + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.logger.info((Object)"Destroying SolR Highlighter service.");
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, UnexpectedException, InvalidParameterException, ContentNotAvailableException, InsufficientResourcesException, UnsupportedRequestException, ServiceNotConfiguredException {
        this.checkArgs(args);
        ResultSet enrichSet = this.highLightHitInResultSet(args.getUsageContext(), (ResultSet)args.getResource());
        ProcessReturn ret = new ProcessReturn();
        ret.setResource((Resource)enrichSet);
        return ret;
    }

    public ResultSet highLightHitInResultSet(String usageContext, ResultSet set) {
        try {
            if (!(set.getResource().get(0) instanceof StringQuery)) {
                throw new WebLabCheckedException("There is no query in the ResultSet.");
            }
            StringQuery query = (StringQuery)set.getResource().get(0);
            WRetrievalAnnotator wra = new WRetrievalAnnotator(new URI(set.getUri()), set.getPok());
            if ((Integer)wra.readNumberOfResults().firstTypedValue() == 0) {
                throw new WebLabCheckedException("There are no results in the ResultSet.");
            }
            int offset = (Integer)wra.readExpectedOffset().firstTypedValue();
            int limit = wra.readHit().size();
            SolrComponent instance = this.noCore ? SolrComponent.getInstance((String)this.solrURL, null) : SolrComponent.getInstance((String)this.solrURL, (String)usageContext);
            QueryResponse response = instance.highlight(query.getRequest(), offset, limit);
            Map highlights = response.getHighlighting();
            JenaPoKHelper hlpr = new JenaPoKHelper(set.getPok(), false);
            for (SolrDocument hit : response.getResults()) {
                String resourceUri = String.valueOf(hit.getFieldValue("id"));
                Set hits = hlpr.getSubjsOnPredRes("http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", resourceUri);
                if (hits.size() != 1) {
                    this.logger.info((Object)("Well, the resultSet is no clear: multiple hits (or none) are linked to [" + resourceUri + "]. Let's try to cope with that..."));
                }
                for (String hitUri : hits) {
                    if (((Map)highlights.get(hit.getFieldValue("id"))).size() > 0) {
                        List hitHighlightingList = (List)((Map)highlights.get(hit.getFieldValue("id"))).get("text");
                        StringBuffer snippet = new StringBuffer();
                        for (String hl : hitHighlightingList) {
                            snippet.append(hl);
                        }
                        hlpr.createLitStat(hitUri, "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasDescription", snippet.toString());
                        continue;
                    }
                    this.logger.info((Object)("No highlighted content for hit [" + hitUri + "] on document [" + resourceUri + "]."));
                }
            }
            hlpr.commit();
            this.logger.info((Object)("Highlighting done for [" + set.getUri() + "]."));
            return set;
        }
        catch (WebLabCheckedException e) {
            this.logger.info((Object)("Cannot highlight results: " + e.getMessage()), (Throwable)e);
        }
        catch (URISyntaxException e) {
            this.logger.info((Object)("Cannot highlight results: " + e.getMessage()), (Throwable)e);
        }
        return set;
    }

    private void checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("Input args for [" + this.getClass().getSimpleName() + "] cannot be null.");
        }
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = solrURL;
    }

    public boolean isNoCore() {
        return this.noCore;
    }

    public void setNoCore(boolean noCore) {
        this.noCore = noCore;
    }
}

