package org.ow2.weblab.services.solr.dataoperator;

import java.net.MalformedURLException;
import java.net.URL;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.DataOperator;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.dataoperator.DeleteArgs;
import org.ow2.weblab.core.services.dataoperator.DeleteReturn;
import org.ow2.weblab.core.services.dataoperator.DropArgs;
import org.ow2.weblab.core.services.dataoperator.DropReturn;
import org.ow2.weblab.core.services.dataoperator.ReportArgs;
import org.ow2.weblab.core.services.dataoperator.ReportReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.indexer.SolrIndexerConfig;
import org.ow2.weblab.services.solr.searcher.SolrSearcher;

@WebService(endpointInterface = "org.ow2.weblab.core.services.DataOperator")
public class SolrDataOperator implements DataOperator {
	public static final String BEAN_NAME = "dataoperatorServiceBean";

	private Log logger = LogFactory.getLog(SolrSearcher.class);
	private String solrURL;

	public String getSolrURL() {
		return solrURL;
	}

	public void setSolrURL(String solrURL) {
		this.solrURL = solrURL;
	}

	@PostConstruct
	public void init() {
		try {// init default instance
			SolrComponent.getInstance(solrURL, null);

			new URL(solrURL);
		} catch (WebLabCheckedException e) {
			throw new WebLabUncheckedException("Cannot start the SolrComponent.", e);
		} catch (MalformedURLException e) {
			throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + solrURL + "].", e);
		}
		logger.debug("SolrDataOperator service started.");
	}

	@PreDestroy
	public void destroy() {
		// nothing to do I guess
		logger.debug("SolrDataOperator service destroyed.");
	}

	@Override
	public DeleteReturn delete(DeleteArgs arg0) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException,
			InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {

		deleteByDocURI(arg0.getUsageContext(), arg0.getUri());

		return new DeleteReturn();
	}

	private boolean deleteByDocURI(String usageContext, String uri) throws UnsupportedRequestException {
		StringBuffer query = new StringBuffer(SolrIndexerConfig.ID_FIELD);
		query.append(':');
		query.append('"');
		query.append(uri);
		query.append('"');
		try {
			doDelete(usageContext, query.toString());
		} catch (WebLabCheckedException e) {
			throw new UnsupportedRequestException("Cannot achieve the request for deletion: " + e.getMessage(), e);
		}
		return true;
	}

	@Override
	public DropReturn drop(DropArgs arg0) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException, InvalidParameterException,
			AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {

		deleteAllDoc(arg0.getUsageContext());

		return new DropReturn();
	}

	private boolean deleteAllDoc(String usageContext) throws UnsupportedRequestException {
		try {
			doDelete(usageContext, "*:*");
		} catch (WebLabCheckedException e) {
			throw new UnsupportedRequestException("Cannot achieve the request for deletion: " + e.getMessage(), e);
		}
		return true;
	}

	@Override
	public ReportReturn report(ReportArgs arg0) throws ServiceNotConfiguredException, InsufficientResourcesException, UnexpectedException,
			InvalidParameterException, AccessDeniedException, ContentNotAvailableException, UnsupportedRequestException {

		// TODO implement it
		throw new ContentNotAvailableException("Method Report is not yet implemented, consult SOLR server adminstration interface here: "+solrURL);
	}

	private void doDelete(String context, String query) throws WebLabCheckedException {
		SolrComponent instance = SolrComponent.getInstance(solrURL, context);
		instance.deleteDocbyQuery(query);
	}

}
