/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.analyser;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.searcher.SolrSearcher;
import org.ow2.weblab.util.index.Field;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class FacetSuggestion
implements Analyser {
    public static final String BEAN_NAME = "facetSuggestionServiceBean";
    public static final String IDRES_FACET_PREFIX = "facets";
    private static long suggestionCounter = 0L;
    private static long queryCounter = 0L;
    private Log logger;
    private String solrURL;
    private Set<Field> facetFields;
    private boolean noCore = false;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(SolrSearcher.class);
        try {
            new URL(this.solrURL);
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.solrURL + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.logger.info((Object)"Destroying SolR FacetSuggestion service.");
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, UnexpectedException, InvalidParameterException, ContentNotAvailableException, InsufficientResourcesException, UnsupportedRequestException, ServiceNotConfiguredException {
        this.checkArgs(args);
        ResultSet enrichSet = this.doFacetSuggest(args.getUsageContext(), (ResultSet)args.getResource());
        ProcessReturn ret = new ProcessReturn();
        ret.setResource((Resource)enrichSet);
        return ret;
    }

    public ResultSet doFacetSuggest(String usageContext, ResultSet set) {
        try {
            if (!(set.getResource().get(0) instanceof StringQuery)) {
                throw new WebLabCheckedException("There is no query in the ResultSet.");
            }
            StringQuery query = (StringQuery)set.getResource().get(0);
            WRetrievalAnnotator wra = new WRetrievalAnnotator(new URI(set.getUri()), set.getPok());
            if ((Integer)wra.readNumberOfResults().firstTypedValue() == 0) {
                throw new WebLabCheckedException("There are no results in the ResultSet.");
            }
            int offset = (Integer)wra.readExpectedOffset().firstTypedValue();
            int limit = wra.readHit().size();
            SolrComponent instance = this.noCore ? SolrComponent.getInstance((String)this.solrURL, null) : SolrComponent.getInstance((String)this.solrURL, (String)usageContext);
            QueryResponse response = instance.facetSuggest(query.getRequest(), offset, limit);
            if (response.getFacetFields() == null || response.getFacetFields().size() == 0) {
                throw new WebLabCheckedException("There are no facets in the ResultSet.");
            }
            ComposedResource cres = (ComposedResource)ResourceFactory.createResource((String)"indexsearch.solr", (String)(IDRES_FACET_PREFIX + suggestionCounter++), ComposedResource.class);
            set.getResource().add(cres);
            for (FacetField facet : response.getFacetFields()) {
                List countList = facet.getValues();
                if (countList == null) {
                    this.logger.debug((Object)("Facet " + facet.getName() + " is empty."));
                    continue;
                }
                for (FacetField.Count valuedFacet : countList) {
                    int nbRes = (int)valuedFacet.getCount();
                    String facetFilter = valuedFacet.getAsFilterQuery();
                    StringQuery facetQuery = (StringQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)("facetsquery" + queryCounter++), StringQuery.class);
                    facetQuery.setRequest(query.getRequest() + ' ' + facetFilter);
                    WRetrievalAnnotator wra4q = new WRetrievalAnnotator((Resource)facetQuery);
                    wra4q.writeNumberOfResults(Integer.valueOf(nbRes));
                    wra4q.writeExpectedOffset(Integer.valueOf(offset));
                    wra4q.writeExpressedWith(this.getClass().getSimpleName());
                    wra4q.writeLabel(facet.getName());
                    wra4q.writeDescription(facetFilter);
                    cres.getResource().add(facetQuery);
                }
            }
            this.logger.info((Object)("Facet suggestion done for [" + set.getUri() + "]."));
        }
        catch (WebLabCheckedException e) {
            this.logger.info((Object)("Cannot make spell suggestion : " + e.getMessage()));
        }
        catch (URISyntaxException e) {
            this.logger.info((Object)("Cannot make spell suggestion : " + e.getMessage()));
        }
        return set;
    }

    private void checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("Input args for [" + this.getClass().getSimpleName() + "] cannot be null.");
        }
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = solrURL;
    }

    public Set<Field> getFacetFields() {
        return this.facetFields;
    }

    public void setFacetFields(Set<Field> facetFields) {
        this.facetFields = facetFields;
    }

    public boolean isNoCore() {
        return this.noCore;
    }

    public void setNoCore(boolean noCore) {
        this.noCore = noCore;
    }
}

